// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 25 1.5.1.4 source/core/collect/ikbhsh.h, collection, ioc.v400, 980918 
#ifndef _IKBHSH_
#define _IKBHSH_

#include <ilanglvl.hpp>
#include <iakb.h>
#include <iickb.h>

#include <iivkb.h>

#include <iikbhsh.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeyBagAsHshTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeyBagAsHshTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGKeyBagAsHshTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeyBagAsHshTableCursor
                            (IGKeyBagAsHshTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagAsHshTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeyBagAsHshTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeyBagAsHshTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeyBagAsHshTable :
  public IAKeyBag <Element, Key> {
protected:

  typedef  IGKeyBagAsHshTable <Element, Key, ElementOps> Self;

  typedef  IKeyBagAsHshTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeyBagImpl
            <PureImplementation> Implementation;
#endif

#define IGKeyBagAsHshTableTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeyBagAsHshTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeyBagAsHshTableCursor
            <Element, Key, ElementOps> Cursor;




           IGKeyBagAsHshTable
                            (INumber = 100);

           IGKeyBagAsHshTable
                            (IGKeyBagAsHshTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagAsHshTable <Element, Key, ElementOps>&
           operator=        (IGKeyBagAsHshTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeyBagAsHshTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeyBagAsHshTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeyBagAsHshTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeyBagAsHshTable :
  public IGKeyBagAsHshTable
          <Element, Key, IKEHOps <Element, Key> > {

  typedef  IGKeyBagAsHshTable
            <Element, Key,
             IKEHOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeyBagAsHshTable <Element, Key> Self;

#define IKeyBagAsHshTableTypedef(Element, Key)\
  typedef  IKeyBagAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, IKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeyBagAsHshTable
                            (INumber = 100);

















protected:

           IKeyBagAsHshTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeyBagAsHshTable :
  public IGKeyBagAsHshTable
          <Element, Key, ElementOps > {

  typedef  IVGKeyBagAsHshTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeyBagAsHshTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeyBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeyBagImpl
            <IVKeyBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeyBagAsHshTableTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeyBagAsHshTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeyBagAsHshTable
                            (INumber = 100);

















protected:

           IVGKeyBagAsHshTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeyBagAsHshTable :
  public IVGKeyBagAsHshTable
          <Element, Key, IKEHOps <Element, Key> > {

  typedef  IVGKeyBagAsHshTable
            <Element, Key,
             IKEHOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeyBagAsHshTable <Element, Key> Self;

#define IVKeyBagAsHshTableTypedef(Element, Key)\
  typedef  IVKeyBagAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, IKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeyBagAsHshTable
                            (INumber = 100);

















protected:

           IVKeyBagAsHshTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ikbhsh.inl>


#pragma info (restore)


#endif // _IKBHSH_
