// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 23 1.5.1.4 source/core/collect/ikbdil.h, collection, ioc.v400, 980918 
#ifndef _IKBDIL_
#define _IKBDIL_

#include <ilanglvl.hpp>
#include <iakb.h>
#include <iickb.h>

#include <iivkb.h>

#include <iikbdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeyBagAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeyBagAsDilTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGKeyBagAsDilTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeyBagAsDilTableCursor
                            (IGKeyBagAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagAsDilTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeyBagAsDilTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeyBagAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeyBagAsDilTable :
  public IAKeyBag <Element, Key> {
protected:

  typedef  IGKeyBagAsDilTable <Element, Key, ElementOps> Self;

  typedef  IKeyBagAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeyBagImpl
            <PureImplementation> Implementation;
#endif

#define IGKeyBagAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeyBagAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeyBagAsDilTableCursor
            <Element, Key, ElementOps> Cursor;




           IGKeyBagAsDilTable
                            (INumber = 100);

           IGKeyBagAsDilTable
                            (IGKeyBagAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagAsDilTable <Element, Key, ElementOps>&
           operator=        (IGKeyBagAsDilTable
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeyBagAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeyBagAsDilTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeyBagAsDilTableCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeyBagAsDilTable :
  public IGKeyBagAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeyBagAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeyBagAsDilTable <Element, Key> Self;

#define IKeyBagAsDilTableTypedef(Element, Key)\
  typedef  IKeyBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeyBagAsDilTable
                            (INumber = 100);

















protected:

           IKeyBagAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeyBagAsDilTable :
  public IGKeyBagAsDilTable
          <Element, Key, ElementOps > {

  typedef  IVGKeyBagAsDilTable
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeyBagAsDilTable
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeyBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeyBagImpl
            <IVKeyBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeyBagAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeyBagAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeyBagAsDilTable
                            (INumber = 100);

















protected:

           IVGKeyBagAsDilTable
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeyBagAsDilTable :
  public IVGKeyBagAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeyBagAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeyBagAsDilTable <Element, Key> Self;

#define IVKeyBagAsDilTableTypedef(Element, Key)\
  typedef  IVKeyBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeyBagAsDilTable
                            (INumber = 100);

















protected:

           IVKeyBagAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ikbdil.inl>


#pragma info (restore)


#endif // _IKBDIL_
