// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 21 1.5.1.4 source/core/collect/ikb.h, collection, ioc.v400, 980918 
#ifndef _IKB_
#define _IKB_

#include <ilanglvl.hpp>
#include <iakb.h>
#include <iickb.h>

#include <iivkb.h>

#include <iikbhsh.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class Key, class ElementOps>
class IGKeyBag;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key, class ElementOps>
class IGKeyBagCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGKeyBag
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeyBagCursor
                            (IGKeyBag
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagCursor <Element, Key, ElementOps>&
           operator=        (IGKeyBagCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeyBagCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class Key, class ElementOps>
class IGKeyBag :
  public IAKeyBag <Element, Key> {
protected:

  typedef  IGKeyBag <Element, Key, ElementOps> Self;

  typedef  IKeyBagAsHshTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeyBagImpl
            <PureImplementation> Implementation;
#endif

#define IGKeyBagTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeyBagTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGKeyBagCursor
            <Element, Key, ElementOps> Cursor;




           IGKeyBag
                            (INumber = 100);

           IGKeyBag
                            (IGKeyBag
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBag <Element, Key, ElementOps>&
           operator=        (IGKeyBag
                              <
                               Element, Key, ElementOps> const&);



















protected:

           IGKeyBag
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeyBag
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeyBagCursor <Element, Key, ElementOps>;






















};

template <class Element, class Key>
class IKeyBag :
  public IGKeyBag
          <Element, Key, IKEHOps <Element, Key> > {

  typedef  IGKeyBag
            <Element, Key,
             IKEHOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IKeyBag <Element, Key> Self;

#define IKeyBagTypedef(Element, Key)\
  typedef  IKeyBagAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, IKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IKeyBag
                            (INumber = 100);

















protected:

           IKeyBag
                              (PureImplementation&);

private:












};


template <class Element, class Key, class ElementOps>
class IVGKeyBag :
  public IGKeyBag
          <Element, Key, ElementOps > {

  typedef  IVGKeyBag
            <Element, Key, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGKeyBag
            <Element, Key, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVKeyBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeyBagImpl
            <IVKeyBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeyBagTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeyBagTypedef (Element, Key, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGKeyBag
                            (INumber = 100);

















protected:

           IVGKeyBag
                              (PureImplementation&);

private:












};

template <class Element, class Key>
class IVKeyBag :
  public IVGKeyBag
          <Element, Key, IKEHOps <Element, Key> > {

  typedef  IVGKeyBag
            <Element, Key,
             IKEHOps <Element, Key> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVKeyBag <Element, Key> Self;

#define IVKeyBagTypedef(Element, Key)\
  typedef  IVKeyBagAsHshTableOps\
            <Element, Key,\
             IWKEHOps <Element, Key, IKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVKeyBag
                            (INumber = 100);

















protected:

           IVKeyBag
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ikb.inl>


#pragma info (restore)


#endif // _IKB_
