// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 18 1.6.1.4 source/core/collect/iivsr.h, collection, ioc.v400, 980918 
#ifndef _IIVSR_
#define _IIVSR_

#include <ilanglvl.hpp>
#include <iiasr.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class VInherited>
class IVSortedRelationImpl : public VInherited {
public:

  typedef TYPENAME VInherited::Ops Ops;

           IVSortedRelationImpl
                            (Ops&, INumber);

           IVSortedRelationImpl
                            (Ops&, IVSortedRelationImpl
                                    <VInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAntivalence   (IASortedRelationImpl const&,
                             IASortedRelationImpl const&);

  void     AddDifference    (IASortedRelationImpl const&,
                             IASortedRelationImpl const&);

  void     AddIntersection  (IASortedRelationImpl const&,
                             IASortedRelationImpl const&);

  void     AddUnion         (IASortedRelationImpl const&,
                             IASortedRelationImpl const&);

  void     Antivalence      (IASortedRelationImpl const&);

  bool     AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  void     Copy             (IACollectionImpl const&);

  void     Difference       (IASortedRelationImpl const&);

  void     Intersection     (IASortedRelationImpl const&);

  bool     LocateOrAdd      (void const*, ICursorImpl&);

  bool     LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  bool     Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  bool     RemoveElementWithKey
                            (void const*);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  bool     ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  void     Union            (IASortedRelationImpl const&);

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iivsr.c>
#endif



#pragma info (restore)


#endif // _IIVSR_
