// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 16 1.6.1.4 source/core/collect/iivsm.h, collection, ioc.v400, 980918 
#ifndef _IIVSM_
#define _IIVSM_

#include <ilanglvl.hpp>
#include <iiasm.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class VInherited>
class IVSortedMapImpl : public VInherited {
public:

  typedef TYPENAME VInherited::Ops Ops;

           IVSortedMapImpl
                            (Ops&, INumber);

           IVSortedMapImpl
                            (Ops&, IVSortedMapImpl
                                    <VInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAntivalence   (IASortedMapImpl const&,
                             IASortedMapImpl const&);

  void     AddDifference    (IASortedMapImpl const&,
                             IASortedMapImpl const&);

  void     AddIntersection  (IASortedMapImpl const&,
                             IASortedMapImpl const&);

  void     AddUnion         (IASortedMapImpl const&,
                             IASortedMapImpl const&);

  void     Antivalence      (IASortedMapImpl const&);

  bool     AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  void     Copy             (IACollectionImpl const&);

  void     Difference       (IASortedMapImpl const&);

  void     Intersection     (IASortedMapImpl const&);

  bool     LocateOrAdd      (void const*, ICursorImpl&);

  bool     LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  bool     Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  bool     RemoveElementWithKey
                            (void const*);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  bool     ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  void     Union            (IASortedMapImpl const&);

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iivsm.c>
#endif



#pragma info (restore)


#endif // _IIVSM_
