// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 14 1.6.1.4 source/core/collect/iivset.h, collection, ioc.v400, 980918 
#ifndef _IIVSET_
#define _IIVSET_

#include <ilanglvl.hpp>
#include <iiaset.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class VInherited>
class IVSetImpl : public VInherited {
public:

  typedef TYPENAME VInherited::Ops Ops;

           IVSetImpl
                            (Ops&, INumber);

           IVSetImpl
                            (Ops&, IVSetImpl
                                    <VInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAntivalence   (IASetImpl const&,
                             IASetImpl const&);

  void     AddDifference    (IASetImpl const&,
                             IASetImpl const&);

  void     AddIntersection  (IASetImpl const&,
                             IASetImpl const&);

  void     AddUnion         (IASetImpl const&,
                             IASetImpl const&);

  void     Antivalence      (IASetImpl const&);

  void     Copy             (IACollectionImpl const&);

  void     Difference       (IASetImpl const&);

  void     Intersection     (IASetImpl const&);

  bool     LocateOrAdd      (void const*, ICursorImpl&);

  bool     Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     Union            (IASetImpl const&);

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iivset.c>
#endif



#pragma info (restore)


#endif // _IIVSET_
