// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 10 1.6.1.4 source/core/collect/iivsb.h, collection, ioc.v400, 980918 
#ifndef _IIVSB_
#define _IIVSB_

#include <ilanglvl.hpp>
#include <iiasb.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class VInherited>
class IVSortedBagImpl : public VInherited {
public:

  typedef TYPENAME VInherited::Ops Ops;

           IVSortedBagImpl
                            (Ops&, INumber);

           IVSortedBagImpl
                            (Ops&, IVSortedBagImpl
                                    <VInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAntivalence   (IASortedBagImpl const&,
                             IASortedBagImpl const&);

  void     AddDifference    (IASortedBagImpl const&,
                             IASortedBagImpl const&);

  void     AddIntersection  (IASortedBagImpl const&,
                             IASortedBagImpl const&);

  void     AddUnion         (IASortedBagImpl const&,
                             IASortedBagImpl const&);

  void     Antivalence      (IASortedBagImpl const&);

  void     Copy             (IACollectionImpl const&);

  void     Difference       (IASortedBagImpl const&);

  void     Intersection     (IASortedBagImpl const&);

  bool     LocateOrAdd      (void const*, ICursorImpl&);

  bool     Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     Union            (IASortedBagImpl const&);

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iivsb.c>
#endif



#pragma info (restore)


#endif // _IIVSB_
