// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 08 1.6.1.4 source/core/collect/iivrel.h, collection, ioc.v400, 980918 
#ifndef _IIVREL_
#define _IIVREL_

#include <ilanglvl.hpp>
#include <iiarel.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class VInherited>
class IVRelationImpl : public VInherited {
public:

  typedef TYPENAME VInherited::Ops Ops;

           IVRelationImpl
                            (Ops&, INumber);

           IVRelationImpl
                            (Ops&, IVRelationImpl
                                    <VInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAntivalence   (IARelationImpl const&,
                             IARelationImpl const&);

  void     AddDifference    (IARelationImpl const&,
                             IARelationImpl const&);

  void     AddIntersection  (IARelationImpl const&,
                             IARelationImpl const&);

  void     AddUnion         (IARelationImpl const&,
                             IARelationImpl const&);

  void     Antivalence      (IARelationImpl const&);

  bool     AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  void     Copy             (IACollectionImpl const&);

  void     Difference       (IARelationImpl const&);

  void     Intersection     (IARelationImpl const&);

  bool     LocateOrAdd      (void const*, ICursorImpl&);

  bool     LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  bool     Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  bool     RemoveElementWithKey
                            (void const*);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  bool     ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  void     Union            (IARelationImpl const&);

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iivrel.c>
#endif



#pragma info (restore)


#endif // _IIVREL_
