// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 04 1.6.1.4 source/core/collect/iivmap.h, collection, ioc.v400, 980918 
#ifndef _IIVMAP_
#define _IIVMAP_

#include <ilanglvl.hpp>
#include <iiamap.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class VInherited>
class IVMapImpl : public VInherited {
public:

  typedef TYPENAME VInherited::Ops Ops;

           IVMapImpl
                            (Ops&, INumber);

           IVMapImpl
                            (Ops&, IVMapImpl
                                    <VInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAntivalence   (IAMapImpl const&,
                             IAMapImpl const&);

  void     AddDifference    (IAMapImpl const&,
                             IAMapImpl const&);

  void     AddIntersection  (IAMapImpl const&,
                             IAMapImpl const&);

  void     AddUnion         (IAMapImpl const&,
                             IAMapImpl const&);

  void     Antivalence      (IAMapImpl const&);

  bool     AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  void     Copy             (IACollectionImpl const&);

  void     Difference       (IAMapImpl const&);

  void     Intersection     (IAMapImpl const&);

  bool     LocateOrAdd      (void const*, ICursorImpl&);

  bool     LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  bool     Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  bool     RemoveElementWithKey
                            (void const*);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  bool     ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  void     Union            (IAMapImpl const&);

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iivmap.c>
#endif



#pragma info (restore)


#endif // _IIVMAP_
