// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 98 1.6.1.4 source/core/collect/iivks.h, collection, ioc.v400, 980918 
#ifndef _IIVKS_
#define _IIVKS_

#include <ilanglvl.hpp>
#include <iiaks.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class VInherited>
class IVKeySetImpl : public VInherited {
public:

  typedef TYPENAME VInherited::Ops Ops;

           IVKeySetImpl
                            (Ops&, INumber);

           IVKeySetImpl
                            (Ops&, IVKeySetImpl
                                    <VInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  bool     AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  void     Copy             (IACollectionImpl const&);

  bool     LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  bool     RemoveElementWithKey
                            (void const*);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  bool     ReplaceElementWithKey
                            (void const*, ICursorImpl&);

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iivks.c>
#endif



#pragma info (restore)


#endif // _IIVKS_
