// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 96 1.6.1.4 source/core/collect/iivkb.h, collection, ioc.v400, 980918 
#ifndef _IIVKB_
#define _IIVKB_

#include <ilanglvl.hpp>
#include <iiakb.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class VInherited>
class IVKeyBagImpl : public VInherited {
public:

  typedef TYPENAME VInherited::Ops Ops;

           IVKeyBagImpl
                            (Ops&, INumber);

           IVKeyBagImpl
                            (Ops&, IVKeyBagImpl
                                    <VInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  bool     AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  void     Copy             (IACollectionImpl const&);

  bool     LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  bool     RemoveElementWithKey
                            (void const*);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  bool     ReplaceElementWithKey
                            (void const*, ICursorImpl&);

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iivkb.c>
#endif



#pragma info (restore)


#endif // _IIVKB_
