// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 94 1.6.1.4 source/core/collect/iivhp.h, collection, ioc.v400, 980918 
#ifndef _IIVHP_
#define _IIVHP_

#include <ilanglvl.hpp>
#include <iiahp.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class VInherited>
class IVHeapImpl : public VInherited {
public:

  typedef TYPENAME VInherited::Ops Ops;

           IVHeapImpl
                            (Ops&, INumber);

           IVHeapImpl
                            (Ops&, IVHeapImpl
                                    <VInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     Copy             (IACollectionImpl const&);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     ReplaceAt        (ICursorImpl const&, void const*);

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iivhp.c>
#endif



#pragma info (restore)


#endif // _IIVHP_
