// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 92 1.6.1.4 source/core/collect/iives.h, collection, ioc.v400, 980918 
#ifndef _IIVES_
#define _IIVES_

#include <ilanglvl.hpp>
#include <iiaes.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class VInherited>
class IVEqualitySequenceImpl : public VInherited {
public:

  typedef TYPENAME VInherited::Ops Ops;

           IVEqualitySequenceImpl
                            (Ops&, INumber);

           IVEqualitySequenceImpl
                            (Ops&, IVEqualitySequenceImpl
                                    <VInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAsFirst       (void const*, ICursorImpl&);

  void     AddAsLast        (void const*, ICursorImpl&);

  void     AddAsNext        (void const*, ICursorImpl&);

  void     AddAsPrevious    (void const*, ICursorImpl&);

  void     AddAtPosition    (IPosition, void const*, ICursorImpl&);

  void     Copy             (IACollectionImpl const&);

  bool     LocateOrAdd      (void const*, ICursorImpl&);

  bool     Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     Reverse          ();

  void     Sort             (ICompFunc, void*);

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iives.c>
#endif



#pragma info (restore)


#endif // _IIVES_
