// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 89 1.5.1.4 source/core/collect/iivcllct.h, collection, ioc.v400, 980918 
#ifndef _IIVCLLCT_
#define _IIVCLLCT_

#include <iiglobal.h>
#include <istdntfy.hpp>





#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ICursor;

class ICursorImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Element>
class IVCollectionEventData
{
public:

           IVCollectionEventData
                            (ICursor const&, Element const* = 0);

  ICursor const&
           cursor           () const;

  Element const*const
           element          () const;

protected:

private:

  ICursor const*
           ivCursor;

  Element const*
           ivElement;

};









class IC_EXPORTC IVCollectionImpl : public IStandardNotifier
{
  typedef  IStandardNotifier Inherited;

public:

  static
  INotificationId const
  IC_IMPORTB addId,
  IC_IMPORTB modifyId,
  IC_IMPORTB removeId,
  IC_IMPORTB replaceId;

  // for backward compatibility
  static
  INotificationId const
  IC_IMPORTB addedId,
  IC_IMPORTB modifiedId,
  IC_IMPORTB removedId,
  IC_IMPORTB replacedId;

          ~IVCollectionImpl ();

  INotifier&
           DisableNotification
                            ();

  INotifier&
           EnableNotification
                            (bool = true);

  bool IsEnabledForNotification
                            () const;

protected:

           IVCollectionImpl ();

  void     NotifyOfAddAt    (ICursorImpl const&);

  void     NotifyOfModification
                            ();

  void     NotifyOfRemoveAt (ICursorImpl const&);

  void     NotifyOfReplaceAt
                            (ICursorImpl const&, void const* = 0);

private:



























};

#pragma enum(pop)
#pragma pack(pop)

typedef IVCollectionImpl IVCollection;

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iivcllct.inl>


#pragma info (restore)


#endif // _IIVCLLCT_
