// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 87 1.6.1.4 source/core/collect/iivbag.h, collection, ioc.v400, 980918 
#ifndef _IIVBAG_
#define _IIVBAG_

#include <ilanglvl.hpp>
#include <iiabag.h>










#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class VInherited>
class IVBagImpl : public VInherited {
public:

  typedef TYPENAME VInherited::Ops Ops;

           IVBagImpl
                            (Ops&, INumber);

           IVBagImpl
                            (Ops&, IVBagImpl
                                    <VInherited> const&);

  bool     Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAntivalence   (IABagImpl const&,
                             IABagImpl const&);

  void     AddDifference    (IABagImpl const&,
                             IABagImpl const&);

  void     AddIntersection  (IABagImpl const&,
                             IABagImpl const&);

  void     AddUnion         (IABagImpl const&,
                             IABagImpl const&);

  void     Antivalence      (IABagImpl const&);

  void     Copy             (IACollectionImpl const&);

  void     Difference       (IABagImpl const&);

  void     Intersection     (IABagImpl const&);

  bool     LocateOrAdd      (void const*, ICursorImpl&);

  bool     Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     Union            (IABagImpl const&);

protected:

private:












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iivbag.c>
#endif



#pragma info (restore)


#endif // _IIVBAG_
