// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 83 1.4.1.3 source/core/collect/iitable.h, collection, ioc.v400, 980918 
#ifndef _IITABLE_
#define _IITABLE_

#include <iiglobal.h>
#include <stddef.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)






#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

struct ITableImpl
{
  INumber  ivFirst,
           ivLast;

  INumber  ivAllocatedElements,
           ivNumberOfElements;

  void*    ivNodes;

  size_t   ivNodeSize;

  INumber& AddMod           (INumber&, INumber) const;

  bool CanAdd           (INumber) const;

  INumber& DecMod           (INumber&) const;

  INumber& IncMod           (INumber&) const;

  void*    NodeAtIndex      (INumber) const;

  INumber  Pos              (INumber) const;

};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iitable.inl>


#pragma info (restore)


#endif // _IITABLE_
