// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 82 1.6.1.3 source/core/collect/iistream.h, collection, ioc.v400, 980918 
#ifndef _IISTREAM_
#define _IISTREAM_


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)


#if ! defined (__INO_STREAMING__)
#include <string.h>
#include <iastr.h>

#define STREAMING_VERSION    1
#define MAX_CLASSNAME_LENGTH 30

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

class IStreamerPtr
{
public:

  IStreamerPtr ()
  : ivPtrRc (0)
  {
  };

  IStreamerPtr (IACollectionStreamer*);

  IStreamerPtr (IStreamerPtr const& ptr)
  { ivPtrRc = ptr.ivPtrRc;
    if (ivPtrRc != 0) ivPtrRc->ivRc++;
  };

  IStreamerPtr&
  operator= (IStreamerPtr const& ptr)
  { if (this != &ptr) {
      if (ivPtrRc && --ivPtrRc->ivRc == 0) delete ivPtrRc;
      ivPtrRc = ptr.ivPtrRc;
      if (ivPtrRc != 0) ivPtrRc->ivRc++;
    }
    return *this;
  };

  IACollectionStreamer* operator-> () const;

  operator IACollectionStreamer* () const;

  IACollectionStreamer& operator* () const;

  IACollectionStreamer* PtrOf () const
  { return (ivPtrRc ? ivPtrRc->ivPtr : 0);
  }

  ~IStreamerPtr     ()
  { if (ivPtrRc != 0 && --ivPtrRc->ivRc == 0) delete ivPtrRc;
  };

private:
  struct PtrRc
  { IACollectionStreamer *ivPtr;

    unsigned int ivRc;

             PtrRc (IACollectionStreamer *ptr)
             : ivPtr (ptr), ivRc (1)
             {
             }

            ~PtrRc ()
             { delete ivPtr; }

  } *ivPtrRc;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif


#pragma info (restore)


#endif // _IISTREAM_
