// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 81 1.6.1.3 source/core/collect/iisstab.h, collection, ioc.v400, 980918 
#ifndef _IISSTAB_
#define _IISSTAB_

#include <iisskss.h>
#include <iiksstab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef ISortedSetOnKeySortedSetImpl
         <IKeySortedSetAsTableImpl> ISortedSetAsTableImpl;

typedef IASortedSetOnKeySortedSetOps
         <IKeySortedSetAsTableImpl> IASortedSetAsTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC ISortedSetAsTableOps :
  public IASortedSetAsTableOps {

  typedef  ISortedSetAsTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsTableOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeySortedSetAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISortedSetAsTableOps
                           (INumber);

           ISortedSetAsTableOps
                           (INumber, void*);

           ISortedSetAsTableOps
                           (ISortedSetAsTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~ISortedSetAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsTableImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#include <iisstab.c>



#pragma info (restore)


#endif // _IISSTAB_
