// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 78 1.6.1.3 source/core/collect/iisslst.h, collection, ioc.v400, 980918 
#ifndef _IISSLST_
#define _IISSLST_

#include <iisskss.h>
#include <iiksslst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef ISortedSetOnKeySortedSetImpl
         <IKeySortedSetAsListImpl> ISortedSetAsListImpl;

typedef IASortedSetOnKeySortedSetOps
         <IKeySortedSetAsListImpl> IASortedSetAsListOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC ISortedSetAsListOps :
  public IASortedSetAsListOps {

  typedef  ISortedSetAsListOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsListOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeySortedSetAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISortedSetAsListOps
                           (INumber);

           ISortedSetAsListOps
                           (INumber, void*);

           ISortedSetAsListOps
                           (ISortedSetAsListOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~ISortedSetAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsListImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#include <iisslst.c>



#pragma info (restore)


#endif // _IISSLST_
