// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 74 1.6.1.3 source/core/collect/iisskss.h, collection, ioc.v400, 980918 
#ifndef _IISSKSS_
#define _IISSKSS_

#include <ilanglvl.hpp>
#include <iiass.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Base>
class ISortedSetOnKeySortedSetMngCursorImpl;

template <class Base>
class ISortedSetOnKeySortedSetImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Base>
class IC_EXPORTC ISortedSetOnKeySortedSetMngCursorImpl :
  public Base::MngCursor {

  typedef TYPENAME Base::MngCursor Inherited;

public:

           ISortedSetOnKeySortedSetMngCursorImpl
                            (ISortedSetOnKeySortedSetImpl
                              <Base> const&);

protected:

private:










};

template <class Base>
class IASortedSetOnKeySortedSetOps;

template <class Base>
class IC_EXPORTC ISortedSetOnKeySortedSetImpl : public IASortedSetImpl {

  typedef  IASortedSetImpl Inherited;

  typedef  ISortedSetOnKeySortedSetImpl <Base> Self;

public:

  typedef  IASortedSetOnKeySortedSetOps <Base> Ops;

  typedef TYPENAME Base::Cursor Cursor;

  typedef  ISortedSetOnKeySortedSetMngCursorImpl <Base> MngCursor;

           ISortedSetOnKeySortedSetImpl
                            (Ops&, INumber);

           ISortedSetOnKeySortedSetImpl
                            (Ops&,
                             ISortedSetOnKeySortedSetImpl
                              <Base> const&);

          ~ISortedSetOnKeySortedSetImpl
                            ();

  bool Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  bool CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  bool Contains         (void const*) const;

  bool ContainsAllFrom  (IACollectionImpl const&) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    First            () const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFirstAt        (ICursorImpl const&) const;

  bool IsFull           () const;

  bool IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  bool Locate           (void const*, ICursorImpl&) const;

  bool LocateNext       (void const*, ICursorImpl&) const;

  bool LocateOrAdd      (void const*, ICursorImpl&);

  INumber  NumberOfElements () const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  bool Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToLast        (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  bool SetToPrevious    (ICursorImpl&) const;

  void     operator=        (ISortedSetOnKeySortedSetImpl
                              <Base> const&);

  bool operator==       (IASortedSetImpl const&) const;

protected:

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (ISortedSetOnKeySortedSetImpl
                              <Base> const&);

  static
  Ops&     OpsOf            (ISortedSetOnKeySortedSetImpl
                              <Base> const&);

  friend
  class    ISortedSetOnKeySortedSetMngCursorImpl <Base>;

#if ! defined (__INO_STREAMING__)
public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif























};

template <class Base>
class IC_EXPORTC IASortedSetOnKeySortedSetOps {
public:

  virtual ~IASortedSetOnKeySortedSetOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual  operator Base&   () = 0;

protected:

private:








};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iisskss.inl>


#pragma info (restore)


#endif // _IISSKSS_
