// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 66 1.6.1.3 source/core/collect/iissavl.h, collection, ioc.v400, 980918 
#ifndef _IISSAVL_
#define _IISSAVL_

#include <iisskss.h>
#include <iikssavl.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef ISortedSetOnKeySortedSetImpl
         <IKeySortedSetAsAvlTreeImpl> ISortedSetAsAvlTreeImpl;

typedef IASortedSetOnKeySortedSetOps
         <IKeySortedSetAsAvlTreeImpl> IASortedSetAsAvlTreeOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC ISortedSetAsAvlTreeOps :
  public IASortedSetAsAvlTreeOps {

  typedef  ISortedSetAsAvlTreeOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsAvlTreeOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeySortedSetAsAvlTreeImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISortedSetAsAvlTreeOps
                           (INumber);

           ISortedSetAsAvlTreeOps
                           (INumber, void*);

           ISortedSetAsAvlTreeOps
                           (ISortedSetAsAvlTreeOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~ISortedSetAsAvlTreeOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsAvlTreeImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#include <iissavl.c>



#pragma info (restore)


#endif // _IISSAVL_
