// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 63 1.6.1.3 source/core/collect/iisrtab.h, collection, ioc.v400, 980918 
#ifndef _IISRTAB_
#define _IISRTAB_

#include <iisrksb.h>
#include <iiksbtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef ISortedRelationOnKeySortedBagImpl
         <IKeySortedBagAsTableImpl> ISortedRelationAsTableImpl;

typedef IASortedRelationOnKeySortedBagOps
         <IKeySortedBagAsTableImpl> IASortedRelationAsTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC ISortedRelationAsTableOps :
  public IASortedRelationAsTableOps {

  typedef  ISortedRelationAsTableOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeySortedBagAsTableOps
            <Element, _Key,
             ElementOps, IKeySortedBagAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           ISortedRelationAsTableOps
                           (INumber);

           ISortedRelationAsTableOps
                           (INumber, void*);

           ISortedRelationAsTableOps
                           (ISortedRelationAsTableOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~ISortedRelationAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

  bool     EqualElements   (void const*, void const*) const;

           operator IKeySortedBagAsTableImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#include <iisrtab.c>



#pragma info (restore)


#endif // _IISRTAB_
