// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 56 1.6.1.3 source/core/collect/iisrksb.h, collection, ioc.v400, 980918 
#ifndef _IISRKSB_
#define _IISRKSB_

#include <ilanglvl.hpp>
#include <iiasr.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Base>
class ISortedRelationOnKeySortedBagMngCursorImpl;

template <class Base>
class ISortedRelationOnKeySortedBagImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Base>
class IC_EXPORTC ISortedRelationOnKeySortedBagMngCursorImpl :
  public Base::MngCursor {

  typedef TYPENAME Base::MngCursor Inherited;

public:

           ISortedRelationOnKeySortedBagMngCursorImpl
                            (ISortedRelationOnKeySortedBagImpl
                              <Base> const&);

          ~ISortedRelationOnKeySortedBagMngCursorImpl
                            ();

protected:

private:










};

template <class Base>
class IASortedRelationOnKeySortedBagOps;

template <class Base>
class IC_EXPORTC ISortedRelationOnKeySortedBagImpl :
  public IASortedRelationImpl {

  typedef  IASortedRelationImpl Inherited;

  typedef  ISortedRelationOnKeySortedBagImpl <Base> Self;

public:

  typedef  IASortedRelationOnKeySortedBagOps <Base> Ops;

  typedef TYPENAME Base::Cursor Cursor;

  typedef  ISortedRelationOnKeySortedBagMngCursorImpl <Base> MngCursor;

           ISortedRelationOnKeySortedBagImpl
                            (Ops&, INumber);

           ISortedRelationOnKeySortedBagImpl
                            (Ops&,
                             ISortedRelationOnKeySortedBagImpl
                              <Base> const&);

          ~ISortedRelationOnKeySortedBagImpl
                            ();

  bool Add              (void const*, ICursorImpl&);

  bool AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  bool CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  bool Contains         (void const*) const;

  bool ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  bool ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    ElementWithKey   (void const*) const;

  void*    First            () const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFirstAt        (ICursorImpl const&) const;

  bool IsFull           () const;

  bool IsLastAt         (ICursorImpl const&) const;

  void*    Key              (void const*) const;

  void*    Last             () const;

  bool Locate           (void const*, ICursorImpl&) const;

  bool LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  bool LocateNext       (void const*, ICursorImpl&) const;

  bool LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  bool LocateOrAdd      (void const*, ICursorImpl&);

  bool LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfDifferentKeys
                            () const;

  INumber  NumberOfElements () const;

  INumber  NumberOfElementsWithKey
                            (void const*) const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  bool Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  bool RemoveElementWithKey
                            (void const*);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  bool ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToLast        (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  bool SetToNextWithDifferentKey
                            (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  bool SetToPrevious    (ICursorImpl&) const;

  void     operator=        (ISortedRelationOnKeySortedBagImpl
                              <Base> const&);

  bool operator==       (IASortedRelationImpl const&) const;

protected:

  bool EqualElements    (void const*, void const*) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (ISortedRelationOnKeySortedBagImpl
                              <Base> const&);

  static
  Ops&     OpsOf            (ISortedRelationOnKeySortedBagImpl
                              <Base> const&);

  friend
  class    ISortedRelationOnKeySortedBagMngCursorImpl <Base>;

#if ! defined (__INO_STREAMING__)
public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif
























};

template <class Base>
class IC_EXPORTC IASortedRelationOnKeySortedBagOps {
public:

  virtual ~IASortedRelationOnKeySortedBagOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  bool EqualElements    (void const*, void const*) const = 0;

  virtual  operator Base&   () = 0;

protected:

private:









};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iisrksb.inl>


#pragma info (restore)


#endif // _IISRKSB_
