// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 44 1.6.1.3 source/core/collect/iismkss.h, collection, ioc.v400, 980918 
#ifndef _IISMKSS_
#define _IISMKSS_

#include <ilanglvl.hpp>
#include <iiasm.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Base>
class ISortedMapOnKeySortedSetMngCursorImpl;

template <class Base>
class ISortedMapOnKeySortedSetImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Base>
class IC_EXPORTC ISortedMapOnKeySortedSetMngCursorImpl :
  public Base::MngCursor {

  typedef TYPENAME Base::MngCursor Inherited;

public:

           ISortedMapOnKeySortedSetMngCursorImpl
                            (ISortedMapOnKeySortedSetImpl
                              <Base> const&);

          ~ISortedMapOnKeySortedSetMngCursorImpl
                            ();

protected:

private:










};

template <class Base>
class IASortedMapOnKeySortedSetOps;

template <class Base>
class IC_EXPORTC ISortedMapOnKeySortedSetImpl : public IASortedMapImpl {

  typedef  IASortedMapImpl Inherited;

  typedef  ISortedMapOnKeySortedSetImpl <Base> Self;

public:

  typedef  IASortedMapOnKeySortedSetOps <Base> Ops;

  typedef TYPENAME Base::Cursor Cursor;

  typedef  ISortedMapOnKeySortedSetMngCursorImpl <Base> MngCursor;

           ISortedMapOnKeySortedSetImpl
                            (Ops&, INumber);

           ISortedMapOnKeySortedSetImpl
                            (Ops&,
                             ISortedMapOnKeySortedSetImpl
                              <Base> const&);

          ~ISortedMapOnKeySortedSetImpl
                            ();

  bool Add              (void const*, ICursorImpl&);

  bool AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  bool CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  bool Contains         (void const*) const;

  bool ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  bool ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    ElementWithKey   (void const*) const;

  void*    First            () const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFirstAt        (ICursorImpl const&) const;

  bool IsFull           () const;

  bool IsLastAt         (ICursorImpl const&) const;

  void*    Key              (void const*) const;

  void*    Last             () const;

  bool Locate           (void const*, ICursorImpl&) const;

  bool LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  bool LocateNext       (void const*, ICursorImpl&) const;

  bool LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  bool LocateOrAdd      (void const*, ICursorImpl&);

  bool LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfElements () const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  bool Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  bool RemoveElementWithKey
                            (void const*);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  bool ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToLast        (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  bool SetToPrevious    (ICursorImpl&) const;

  void     operator=        (ISortedMapOnKeySortedSetImpl
                              <Base> const&);

  bool operator==       (IASortedMapImpl const&) const;

protected:

  bool EqualElements    (void const*, void const*) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (ISortedMapOnKeySortedSetImpl
                              <Base> const&);

  static
  Ops&     OpsOf            (ISortedMapOnKeySortedSetImpl
                              <Base> const&);

  friend
  class    ISortedMapOnKeySortedSetMngCursorImpl <Base>;

#if ! defined (__INO_STREAMING__)
public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif
























};

template <class Base>
class IC_EXPORTC IASortedMapOnKeySortedSetOps {
public:

  virtual ~IASortedMapOnKeySortedSetOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  bool EqualElements    (void const*, void const*) const = 0;

  virtual  operator Base&   () = 0;

protected:

private:









};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iismkss.inl>


#pragma info (restore)


#endif // _IISMKSS_
