// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 30 1.6.1.3 source/core/collect/iisetlst.h, collection, ioc.v400, 980918 
#ifndef _IISETLST_
#define _IISETLST_

#include <iisetks.h>
#include <iikslst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef ISetOnKeySetImpl
         <IKeySetAsListImpl> ISetAsListImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC ISetAsListOps :
  public IASetOnKeySetOps <IKeySetAsListImpl> {

  typedef  ISetAsListOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeySetAsListOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeySetAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISetAsListOps
                           (INumber);

           ISetAsListOps
                           (INumber, void*);

           ISetAsListOps
                           (ISetAsListOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~ISetAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySetAsListImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#include <iisetlst.c>



#pragma info (restore)


#endif // _IISETLST_
