// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 26 1.6.1.3 source/core/collect/iisetks.h, collection, ioc.v400, 980918 
#ifndef _IISETKS_
#define _IISETKS_

#include <ilanglvl.hpp>
#include <iiaset.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Base>
class ISetOnKeySetMngCursorImpl;

template <class Base>
class ISetOnKeySetImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Base>
class IC_EXPORTC ISetOnKeySetMngCursorImpl : public Base::MngCursor {

  typedef TYPENAME Base::MngCursor Inherited;

public:

           ISetOnKeySetMngCursorImpl
                            (ISetOnKeySetImpl <Base> const&);

          ~ISetOnKeySetMngCursorImpl
                            ();

protected:

private:









};

template <class Base>
class IASetOnKeySetOps;

template <class Base>
class IC_EXPORTC ISetOnKeySetImpl : public IASetImpl {

  typedef  IASetImpl Inherited;

  typedef  ISetOnKeySetImpl <Base> Self;

public:

  typedef  IASetOnKeySetOps <Base> Ops;

  typedef TYPENAME Base::Cursor Cursor;

  typedef  ISetOnKeySetMngCursorImpl <Base> MngCursor;

           ISetOnKeySetImpl (Ops&, INumber);

           ISetOnKeySetImpl (Ops&, ISetOnKeySetImpl <Base> const&);

          ~ISetOnKeySetImpl ();

  bool Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  bool CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  bool Contains         (void const*) const;

  bool ContainsAllFrom  (IACollectionImpl const&) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFull           () const;

  bool Locate           (void const*, ICursorImpl&) const;

  bool LocateOrAdd      (void const*, ICursorImpl&);

  INumber  NumberOfElements () const;

  bool Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  void     operator=        (ISetOnKeySetImpl <Base> const&);

  bool operator==       (IASetImpl const&) const;

protected:

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (ISetOnKeySetImpl <Base> const&);

  static
  Ops&     OpsOf            (ISetOnKeySetImpl <Base> const&);

  friend
  class    ISetOnKeySetMngCursorImpl <Base>;

#if ! defined (__INO_STREAMING__)
public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif

















};

template <class Base>
class IC_EXPORTC IASetOnKeySetOps {
public:

  virtual ~IASetOnKeySetOps ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual  operator Base&   () = 0;

protected:

private:








};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iisetks.inl>


#pragma info (restore)


#endif // _IISETKS_
