// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 11 1.5.1.3 source/core/collect/iiseqtab.h, collection, ioc.v400, 980918 
#ifndef _IISEQTAB_
#define _IISEQTAB_

#include <iiaseq.h>
#include <iitable.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)






#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum (4)
#pragma pack (push,4)

template <class Element>
struct ISequenceAsTableNodeImpl {

  Element  ivElement;

           ISequenceAsTableNodeImpl
                            (Element const&);

          ~ISequenceAsTableNodeImpl
                            ();

#if ! defined(__INO_STREAMING__)
  void     StreamIn         (IACollectionStreamer*, IDataStream&);
#endif







};










class IC_EXPORTC ISequenceAsTableCursorImpl : public ICursorImpl {

  typedef  ICursorImpl Inherited;

  typedef  ISequenceAsTableCursorImpl Self;

public:

           ISequenceAsTableCursorImpl
                            (IACollectionImpl const&);

           ISequenceAsTableCursorImpl
                            (ISequenceAsTableCursorImpl const&);

          ~ISequenceAsTableCursorImpl
                            ();

  ICursorImpl*
           Clone            () const;

  void     Copy             (ICursorImpl const&);

  void     Invalidate       ();

  bool IsInBetween      () const;

  bool IsValid          () const;

  void     operator=        (ISequenceAsTableCursorImpl const&);

  bool operator==       (ICursorImpl const&) const;

protected:

private:

  INumber  ivIndex;

  friend
  class    ISequenceAsTableImpl;










};




























































class IASequenceAsTableOps;

class IC_EXPORTC ISequenceAsTableImpl : public IASequenceImpl {

  typedef  IASequenceImpl Inherited;

  typedef  ISequenceAsTableImpl Self;

public:

  typedef  IASequenceAsTableOps Ops;

  typedef  ISequenceAsTableCursorImpl Cursor;




  typedef  ISequenceAsTableCursorImpl MngCursor;


           ISequenceAsTableImpl
                            (Ops&, INumber);

           ISequenceAsTableImpl
                            (Ops&,
                             ISequenceAsTableImpl const&);

          ~ISequenceAsTableImpl
                            ();

  bool Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAsFirst       (void const*, ICursorImpl&);

  void     AddAsLast        (void const*, ICursorImpl&);

  void     AddAsNext        (void const*, ICursorImpl&);

  void     AddAsPrevious    (void const*, ICursorImpl&);

  void     AddAtPosition    (IPosition, void const*, ICursorImpl&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    First            () const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFirstAt        (ICursorImpl const&) const;

  bool IsFull           () const;

  bool IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  INumber  NumberOfElements () const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  void     Reverse          ();

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToLast        (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  bool SetToPrevious    (ICursorImpl&) const;

  void     Sort             (ICompFunc, void*);

  void     operator=        (ISequenceAsTableImpl const&);

protected:

  void     Assign           (void*, void const*) const;

  void     BlockLeft        (INumber, INumber);

  void     BlockRight       (INumber, INumber);

  void     CopyFrom         (ITableImpl const&);

  void     ConstructNode    (void*, void const*) const;

  void*    CreateNodes      (INumber, size_t&);

  void     DeleteNodes      (void*);

  void     DestroyNodes     (void*, INumber = 1) const;

  void     Swap             (INumber, INumber) const;

private:

  enum { kOriginalVersion };

  static
  char const*
           cvClassName;

  MngCursor*
           ivMngCursors;

  ITableImpl
           ivTable;

  void     GrowBy           (INumber);

  void*    ElementOf        (void const*) const;

  static
  INumber& IndexOf          (ICursorImpl const&);

  void     Initialize       (INumber);

  static
  bool IsInBetween      (ICursorImpl const&);

  static
  INumber& NextIndexOf      (ICursorImpl const&);

  static
  Ops&     OpsOf            (ISequenceAsTableImpl const&);

  static
  INumber& PreviousIndexOf  (ICursorImpl const&);

  void     RemoveAtIndex    (INumber);

  void     SetInBetween     (MngCursor&) const;

  void     Quicksort        (ICompFunc, void*, INumber, INumber);

  void     UpdateMngCursorsForAssign
                            (INumber, INumber) const;

  void     UpdateMngCursorsForCopyFrom
                            (INumber, INumber) const;

  void     UpdateMngCursorsForGrowBy
                            () const;

  void     UpdateMngCursorsForPredRemove
                            (INumber, INumber) const;

  void     UpdateMngCursorsForRemoveOf
                            (INumber) const;

  void     UpdateMngCursorsForShiftLeftOf
                            (INumber) const;

  void     UpdateMngCursorsForShiftRightOf
                            (INumber) const;

  void     UpdateMngCursorsForSwap
                            (INumber, INumber) const;

  friend
  class    ISequenceAsTableMngCursorImpl;

  friend
  class    IASequenceAsTableOps;

#if ! defined (__INO_STREAMING__)
protected:
  void     AddAsLastFromStreamer
                            (IDataStream&, ICursorImpl&);

  void     ConstructNodeWithStreamer
                            (void*, IDataStream&) const;

public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif




















































};

class IC_EXPORTC IASequenceAsTableOps {
public:

  virtual ~IASequenceAsTableOps
                            ();

  virtual
  void     Assign           (void*, void const*) const = 0;

  virtual
  void     BlockLeft        (INumber, INumber) = 0;

  virtual
  void     BlockRight       (INumber, INumber) = 0;

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  void     CopyFrom         (ITableImpl const&) = 0;

  virtual
  void     ConstructNode    (void*, void const*) const = 0;

  virtual
  void*    CreateNodes      (INumber, size_t&) = 0;

  virtual
  void     DeleteNodes      (void*) = 0;

  virtual
  void     DestroyNodes     (void*, INumber = 1) const = 0;

  virtual
  void     Swap             (INumber, INumber) const = 0;

protected:

           IASequenceAsTableOps
                            (bool);

  static
  ITableImpl&
           TableOf          (ISequenceAsTableImpl const&);

  void     UpdateMngCursorsForAssign
                            (ISequenceAsTableImpl const&,
                             INumber, INumber) const;

  void     UpdateMngCursorsForCopyFrom
                            (ISequenceAsTableImpl const&,
                             INumber, INumber) const;

  void     UpdateMngCursorsForPredRemove
                            (ISequenceAsTableImpl const&,
                             INumber, INumber) const;

  void     UpdateMngCursorsForRemoveOf
                            (ISequenceAsTableImpl const&,
                             INumber) const;

  void     UpdateMngCursorsForShiftLeftOf
                            (ISequenceAsTableImpl const&,
                             INumber) const;

  void     UpdateMngCursorsForShiftRightOf
                            (ISequenceAsTableImpl const&,
                             INumber) const;

  void     UpdateMngCursorsForSwap
                            (ISequenceAsTableImpl const&,
                             INumber, INumber) const;

private:

  bool ivContainsDTSObjects;

  friend
  class    ISequenceAsTableImpl;

#if ! defined (__INO_STREAMING__)
public:
  virtual
  void     ConstructNodeWithStreamer
                         (void*, IACollectionStreamer*, IDataStream&) const = 0;
#endif










































};

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC ISequenceAsTableOps : public IASequenceAsTableOps {

  typedef  IASequenceAsTableOps Inherited;

  typedef  ISequenceAsTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsTableNodeImpl <Element> Node;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISequenceAsTableOps
                            (INumber);

           ISequenceAsTableOps
                            (INumber, void*);

           ISequenceAsTableOps
                            (ISequenceAsTableOps
                              <Element, ElementOps,
                               Implementation> const&);

          ~ISequenceAsTableOps
                            ();

  void     Assign           (void*, void const*) const;

  void     BlockLeft        (INumber, INumber);

  void     BlockRight       (INumber, INumber);

  IACollectionImpl*
           Clone            () const;

  void     CopyFrom         (ITableImpl const&);

  void     ConstructNode    (void*, void const*) const;

  void*    CreateNodes      (INumber, size_t&);

  void     DeleteNodes      (void*);

  void     DestroyNodes     (void*, INumber) const;

  void     Swap             (INumber, INumber) const;

           operator Implementation*
                            ();



















protected:

private:

  ElementOps
           ivElementOps;

  Implementation
           ivImpl;

#if ! defined (__INO_STREAMING__)
public:
  void     ConstructNodeWithStreamer
                            (void*, IACollectionStreamer*, IDataStream&) const;
#endif












};

#pragma pack (pop)
#pragma enum (pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif






#pragma info (restore)


#include <iiseqtab.inl>




#if ! defined (__TEMPINC__)
#include <iiseqtab.c>
#endif


#endif // _IISEQTAB_
