// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 97 1.6.1.4 source/core/collect/iisblst.h, collection, ioc.v400, 980918 
#ifndef _IISBLST_
#define _IISBLST_

#include <iisbksb.h>
#include <iiksblst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef ISortedBagOnKeySortedBagImpl
         <IKeySortedBagAsListImpl> ISortedBagAsListImpl;

typedef IASortedBagOnKeySortedBagOps
          <IKeySortedBagAsListImpl> IASortedBagAsListOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC ISortedBagAsListOps :
  public IASortedBagAsListOps {

  typedef  IASortedBagAsListOps Inherited;

  typedef  ISortedBagAsListOps
            <Element, ElementOps, Implementation> Self;

  typedef  IKeySortedBagAsListOps
            <Element, Element, IOpsWithKey <Element, ElementOps>,
             IKeySortedBagAsListImpl > Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           ISortedBagAsListOps
                           (INumber);

           ISortedBagAsListOps
                           (INumber, void*);

           ISortedBagAsListOps
                           (ISortedBagAsListOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~ISortedBagAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedBagAsListImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iisblst.c>
#endif



#pragma info (restore)


#endif // _IISBLST_
