// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 93 1.6.1.3 source/core/collect/iisbksb.h, collection, ioc.v400, 980918 
#ifndef _IISBKSB_
#define _IISBKSB_

#include <ilanglvl.hpp>
#include <iiasb.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Base>
class ISortedBagOnKeySortedBagMngCursorImpl;

template <class Base>
class ISortedBagOnKeySortedBagImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Base>
class IC_EXPORTC ISortedBagOnKeySortedBagMngCursorImpl :
  public Base::MngCursor {

  typedef TYPENAME Base::MngCursor Inherited;

public:

           ISortedBagOnKeySortedBagMngCursorImpl
                            (ISortedBagOnKeySortedBagImpl <Base> const&);


          ~ISortedBagOnKeySortedBagMngCursorImpl
                            ();

protected:

private:









};

template <class Base>
class IASortedBagOnKeySortedBagOps;

template <class Base>
class IC_EXPORTC ISortedBagOnKeySortedBagImpl : public IASortedBagImpl {

  typedef  IASortedBagImpl Inherited;

  typedef  ISortedBagOnKeySortedBagImpl <Base> Self;

public:

  typedef  IASortedBagOnKeySortedBagOps <Base> Ops;

  typedef TYPENAME Base::Cursor Cursor;

  typedef  ISortedBagOnKeySortedBagMngCursorImpl <Base> MngCursor;

           ISortedBagOnKeySortedBagImpl
                            (Ops&, INumber);

           ISortedBagOnKeySortedBagImpl
                            (Ops&, ISortedBagOnKeySortedBagImpl
                              <Base> const&);

          ~ISortedBagOnKeySortedBagImpl
                            ();

  bool Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  bool CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  bool Contains         (void const*) const;

  bool ContainsAllFrom  (IACollectionImpl const&) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    First            () const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFirstAt        (ICursorImpl const&) const;

  bool IsFull           () const;

  bool IsLastAt         (ICursorImpl const&) const;

  void*    Last             () const;

  bool Locate           (void const*, ICursorImpl&) const;

  bool LocateNext       (void const*, ICursorImpl&) const;

  bool LocateOrAdd      (void const*, ICursorImpl&);

  INumber  NumberOfDifferentElements
                            () const;

  INumber  NumberOfElements () const;

  INumber  NumberOfOccurrences
                            (void const*) const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  bool Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToLast        (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  bool SetToNextDifferentElement
                            (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  bool SetToPrevious    (ICursorImpl&) const;

  void     operator=        (ISortedBagOnKeySortedBagImpl
                              <Base> const&);

  bool operator==       (IASortedBagImpl const&) const;

protected:

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (ISortedBagOnKeySortedBagImpl
                              <Base> const&);

  static
  Ops&     OpsOf            (ISortedBagOnKeySortedBagImpl
                              <Base> const&);

  friend
  class    ISortedBagOnKeySortedBagMngCursorImpl <Base>;

#if ! defined (__INO_STREAMING__)
public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif























};

template <class Base>
class IC_EXPORTC IASortedBagOnKeySortedBagOps {
public:

  virtual ~IASortedBagOnKeySortedBagOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual  operator Base&   () = 0;

protected:

  // for backward compatibility
           IASortedBagOnKeySortedBagOps
                            (bool);

private:










};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iisbksb.inl>


#pragma info (restore)


#endif // _IISBKSB_
