// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 81 1.6.1.3 source/core/collect/iirelkb.h, collection, ioc.v400, 980918 
#ifndef _IIRELKB_
#define _IIRELKB_

#include <ilanglvl.hpp>
#include <iiarel.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Base>
class IRelationOnKeyBagMngCursorImpl;

template <class Base>
class IRelationOnKeyBagImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Base>
class IC_EXPORTC IRelationOnKeyBagMngCursorImpl : public Base::MngCursor
{

  typedef TYPENAME Base::MngCursor Inherited;

public:

           IRelationOnKeyBagMngCursorImpl
                            (IRelationOnKeyBagImpl <Base> const&);

          ~IRelationOnKeyBagMngCursorImpl
                            ();

protected:

private:









};

template <class Base>
class IARelationOnKeyBagOps;

template <class Base>
class IC_EXPORTC IRelationOnKeyBagImpl : public IARelationImpl {

  typedef  IARelationImpl Inherited;

  typedef  IRelationOnKeyBagImpl <Base> Self;

public:

  typedef  IARelationOnKeyBagOps <Base> Ops;

  typedef TYPENAME Base::Cursor Cursor;

  typedef  IRelationOnKeyBagMngCursorImpl <Base> MngCursor;

           IRelationOnKeyBagImpl
                            (Ops&, INumber);

           IRelationOnKeyBagImpl
                            (Ops&, IRelationOnKeyBagImpl <Base> const&);

          ~IRelationOnKeyBagImpl
                            ();

  bool Add              (void const*, ICursorImpl&);

  bool AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  bool CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  bool Contains         (void const*) const;

  bool ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  bool ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementWithKey   (void const*) const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFull           () const;

  void*    Key              (void const*) const;

  bool Locate           (void const*, ICursorImpl&) const;

  bool LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  bool LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  bool LocateOrAdd      (void const*, ICursorImpl&);

  bool LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfDifferentKeys
                            () const;

  INumber  NumberOfElements () const;

  INumber  NumberOfElementsWithKey
                            (void const*) const;

  bool Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  bool RemoveElementWithKey
                            (void const*);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  bool ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  bool SetToNextWithDifferentKey
                            (ICursorImpl&) const;

  void     operator=        (IRelationOnKeyBagImpl <Base> const&);

  bool operator==       (IARelationImpl const&) const;

protected:

  bool EqualElements    (void const*, void const*) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (IRelationOnKeyBagImpl <Base> const&);

  static
  Ops&     OpsOf            (IRelationOnKeyBagImpl <Base> const&);

  friend
  class    IRelationOnKeyBagMngCursorImpl <Base>;

#if ! defined (__INO_STREAMING__)
public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif





















};

template <class Base>
class IC_EXPORTC IARelationOnKeyBagOps {
public:

  virtual ~IARelationOnKeyBagOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  bool EqualElements    (void const*, void const*) const = 0;

  virtual  operator Base&   () = 0;

protected:

private:









};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iirelkb.inl>


#pragma info (restore)


#endif // _IIRELKB_
