// Revision: 33 1.1.1.4 source/ui/baseapp/iinhratt.hpp, basewin, ioc.v400, 980918 
#ifndef _IINHRATT_
  #define _IINHRATT_
/*******************************************************************************
* FILE NAME: iinhratt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IInheritColorAttribute                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <iattribt.hpp>
#include <iatname.hpp>

#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class IInheritColorAttribute : public IAttribute {
typedef IAttribute
  Inherited;
public:
enum EInheritColor {
  kForegroundColor,
  kBackgroundColor,
  kForegroundAndBackgroundColor,
  kNone
  };


/*------------------------------- Constructors -------------------------------*/
  IInheritColorAttribute      ( EInheritColor inheritColor );
  IInheritColorAttribute      ( const IInheritColorAttribute& 
                                    inheritColorAttribute );
virtual
 ~IInheritColorAttribute      ( );

/*------------------------------- Assignment ---------------------------------*/
IInheritColorAttribute
 &operator=                ( const IInheritColorAttribute& 
                                 inheritColorAttribute );

/*------------------------------- Comparison ---------------------------------*/
virtual bool
 operator==                ( const IAttribute& attribute ) const;

/*------------------------------- Alignment ----------------------------------*/
EInheritColor
 inheritColor       ( ) const;
virtual IInheritColorAttribute
 &setInheritColor   ( EInheritColor inheritColor );

/*--------------------------------- Clone ------------------------------------*/
virtual IAttribute
 *clone                    ( ) const; // in lieu of ::Copy()

private:
EInheritColor       fInheritColor;

}; // IInheritColorAttribute

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IINHRATT_ */

