// Revision: 89 1.5.1.5 source/ui/basectl/iinfoa.hpp, staticctls, ioc.v400, 980918 
#ifndef _IINFOA_
  #define _IINFOA_
/*******************************************************************************
* FILE NAME: iinfoa.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IInfoArea                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <istattxt.hpp>
#include <istring.hpp>
#include <ireslib.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IFrameWindow;
class IMenuEvent;
class IModuleHandle;
class IResourceLibrary;
class IInfoAreaData;
class ISize;

#pragma enum(4)
#pragma pack(push,4)

class IInfoArea : public IStaticText {
typedef IStaticText
  Inherited;
public:
/*------------------------------ Constructors --------------------------------*/
  IInfoArea ( IFrameWindow*        frame,
              unsigned long        id = 0 );
  IInfoArea ( IFrameWindow*        frame,
              unsigned long        id,
              const char*          resDLLName );
#ifdef IC_PMWIN
  IInfoArea ( IFrameWindow*        frame,
              const IModuleHandle& resMod,
              unsigned long        id = 0 );
#endif
  IInfoArea ( IFrameWindow*        frame,
              const char*          resDLLName,
              unsigned long        id = 0 );

virtual
 ~IInfoArea ( );

/*----------------------------- Resource Library -----------------------------*/
virtual IResourceLibrary
 &resourceLibrary       ( ) const;

#ifdef IC_PMWIN
virtual IInfoArea
 &setResourceLibrary    ( const IModuleHandle& resMod );
#endif

virtual IInfoArea
 &setResourceLibrary    ( const char*  resDLLName,
                           IDynamicLinkLibrary::ESearchLocation searchLocation =
                                    IDynamicLinkLibrary::kOSDefaultSearch);

/*--------------------------- String Table Offset ----------------------------*/
virtual long
  stringTableOffset     ( ) const;

virtual IInfoArea
 &setStringTableOffset  ( long newOffset = 0 );

/*----------------------- Special Information Strings ------------------------*/
virtual IString
  defaultText           ( ) const,
  disabledText          ( ) const,
  missingText           ( ) const;

virtual IInfoArea
 &setDefaultText       ( unsigned long  defaultText ),
 &setDefaultText       ( const IString& defaultText ),
 &setDisabledText      ( unsigned long  disabledText ),
 &setDisabledText      ( const IString& disabledText ),
 &setMissingText       ( unsigned long  missingText ),
 &setMissingText       ( const IString& missingText );

#ifndef IC_MOTIF_FLAGNOP
/*------------------------------- Display Size -------------------------------*/
virtual unsigned long
  lineCount             ( ) const;
virtual IInfoArea
 &setLineCount          ( unsigned long lines = 1 );
#endif

/*-------------------------- Event Dispatching -------------------------------*/
virtual IInfoArea
  &startShowingMenuInfoFor    ( IFrameWindow* frame ),
  &stopShowingMenuInfoFor     ( IFrameWindow* frame );

/*--------------------------- Notification Members ---------------------------*/
// Attribute Change Notifications
static INotificationId const
  IC_IMPORTU defaultTextId,
  IC_IMPORTU disabledTextId,
  IC_IMPORTU missingTextId,
  IC_IMPORTU resourceLibraryId;

protected:

enum ETextType
  {
  kDefaultText,
  kMissingText,
  kSelectedText,
  kDisabledText
  };

/*---------------------- Information String Processing -----------------------*/
virtual IString
  informationFor        ( unsigned long itemId ) const;

/*-------------------------- Text Display Processing -------------------------*/
virtual IInfoArea
  &showMenuInfo            ( bool itemState, unsigned long itemId,
                             ETextType status, const IString& text );

/*----------------------------- Layout Support -------------------------------*/
virtual ISize
  calcMinimumSize       ( ) const;

private:
/*----------------------------- Hidden Members -------------------------------*/
  IInfoArea  ( const IInfoArea& infoArea );
IInfoArea
 &operator=  ( const IInfoArea& infoArea );

/*--------------------------------- Private ----------------------------------*/
void

  showText              ( bool itemState, unsigned long itemId,
                             ETextType status, const IString& text ),
  addTo                ( IFrameWindow* );
ETextType
  status;
IResourceLibrary
 *pResLib;
long
  strTblOffset;
unsigned long
  currentItem,
  numberOfLines;
IString
  defaultString,
  disabledString,
  missingString;
bool
  itemEnabled,
  preventFlyUpdate;

IInfoAreaData
 *fInfoAreaData;

friend class IInfoAreaMenuHandler;
IInfoAreaMenuHandler
 *fInfoAreaMenuHandler;

/*--------------------------------- Obsolete Members -------------------------*/
#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
public:

virtual IString
  inactiveText           ( ) const;

virtual IInfoArea
  &setInactiveText       ( unsigned long  inactiveText ),
  &setInactiveText       ( const IString& inactiveText ),
  &handleEventsFor       ( IFrameWindow* frame ),
  &stopHandlingEventsFor ( IFrameWindow* frame );

static INotificationId const
  IC_IMPORTU inactiveTextId;

#endif // IC_OBSOLETE


}; // class IInfoArea

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IINFOA_ */
