// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 72 1.6.1.3 source/core/collect/iimwt.h, collection, ioc.v400, 980918 
#ifndef _IIMWT_
#define _IIMWT_

#include <iiatree.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)






#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum (4)
#pragma pack (push,4)

struct IAMultiwayTreeNodeImpl {

  IAMultiwayTreeNodeImpl*
            ivParent;

  IAMultiwayTreeNodeImpl**
            ivChildren;

};

template <INumber numOfChildren, class Element>
struct IMultiwayTreeNodeImpl : public IAMultiwayTreeNodeImpl {

  typedef   IAMultiwayTreeNodeImpl Inherited;

  Element   ivElement;

  IAMultiwayTreeNodeImpl*
            ivChildren [numOfChildren];

            IMultiwayTreeNodeImpl
                             (Element const&);

           ~IMultiwayTreeNodeImpl
                             ();

#if !defined(__INO_STREAMING__)
  void     StreamIn         (IACollectionStreamer*, IDataStream&);
#endif

};













class IC_EXPORTC IMultiwayTreeCursorImpl : public ITreeCursorImpl {

  typedef  ITreeCursorImpl Inherited;

  typedef  IMultiwayTreeCursorImpl Self;

public:

           IMultiwayTreeCursorImpl
                            (IATreeImpl const&);

           IMultiwayTreeCursorImpl
                            (IMultiwayTreeCursorImpl const&);

          ~IMultiwayTreeCursorImpl
                            ();

  ITreeCursorImpl*
           Clone            () const;

  void     Copy             (ITreeCursorImpl const&);

  bool IsValid          () const;

  void     Invalidate       ();

  void     operator=        (IMultiwayTreeCursorImpl const&);

  bool operator==       (ITreeCursorImpl const&) const;

protected:

private:

  IAMultiwayTreeNodeImpl*
           ivNode;

  friend
  class    IMultiwayTreeImpl;










};

class IAMultiwayTreeOps;

class IC_EXPORTC IMultiwayTreeImpl : public IATreeImpl {

  typedef  IATreeImpl Inherited;

  typedef  IMultiwayTreeImpl Self;

  typedef  IAMultiwayTreeNodeImpl Node;

public :

  typedef  IAMultiwayTreeOps Ops;

  typedef  IMultiwayTreeCursorImpl Cursor;

  typedef  IMultiwayTreeCursorImpl MngCursor;

           IMultiwayTreeImpl
                            (Ops&);

           IMultiwayTreeImpl
                            (Ops&, IMultiwayTreeImpl const&);

          ~IMultiwayTreeImpl
                            ();

  void     AddAsChild       (ITreeCursorImpl const&,
                             IPosition, void const*);

  void     AddAsRoot        (void const*);

  bool AllElementsDo    (IApplFunc, ITreeIterationOrder, void*);

  bool AllSubtreeElementsDo
                            (ITreeCursorImpl const&,
                             IApplFunc, ITreeIterationOrder, void*);

  virtual
  void     AttachAsChild    (ITreeCursorImpl const&,
                             IPosition, IMultiwayTreeImpl&);

  virtual
  void     AttachAsRoot     (IMultiwayTreeImpl&);

  virtual
  void     AttachSubtreeAsChild
                            (ITreeCursorImpl const&, IPosition,
                             IMultiwayTreeImpl&,
                             ITreeCursorImpl const&);

  virtual
  void     AttachSubtreeAsRoot
                            (IMultiwayTreeImpl&,
                             ITreeCursorImpl const&);

  bool CheckChild       (ITreeCursorImpl const&, IPosition) const;

  bool CheckCursor      (ITreeCursorImpl const&) const;

  bool CheckCursor      (ITreeCursorImpl const&,
                             ITreeCursorImpl const&) const;

  INumber  ChildPositionAt  (ITreeCursorImpl const&) const;

  char const*
           ClassName        () const;

  IATreeImpl*
           Clone            () const;

  void     Copy             (IMultiwayTreeImpl const&);

  virtual
  void     CopySubtree      (IMultiwayTreeImpl const&,
                             ITreeCursorImpl const&);

  Cursor*  CreateCursor     () const;

  void*    ElementAt        (ITreeCursorImpl const&) const;

  virtual
  bool HasChild         (IPosition, ITreeCursorImpl const&) const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsLeaf           (ITreeCursorImpl const&) const;

  bool IsRoot           (ITreeCursorImpl const&) const;

  INumber  NumberOfChildren () const;

  INumber  NumberOfElements () const;

  INumber  NumberOfLeaves   () const;

  INumber  NumberOfSubtreeElements
                            (ITreeCursorImpl const&) const;

  INumber  NumberOfSubtreeLeaves
                            (ITreeCursorImpl const&) const;

  INumber  RemoveAll        ();

  INumber  RemoveSubtree    (ITreeCursorImpl&);

  void     ReplaceAt        (ITreeCursorImpl const&, void const*);

  bool SetToChild       (IPosition, ITreeCursorImpl&) const;

  bool SetToFirst       (ITreeCursorImpl&,
                             ITreeIterationOrder) const;

  bool SetToFirstExistingChild
                            (ITreeCursorImpl&) const;

  bool SetToLast        (ITreeCursorImpl&,
                             ITreeIterationOrder) const;

  bool SetToLastExistingChild
                            (ITreeCursorImpl&) const;

  bool SetToNext        (ITreeCursorImpl&,
                             ITreeIterationOrder) const;

  bool SetToNextExistingChild
                            (ITreeCursorImpl&) const;

  bool SetToParent      (ITreeCursorImpl&) const;

  bool SetToPrevious    (ITreeCursorImpl&,
                             ITreeIterationOrder) const;

  bool SetToPreviousExistingChild
                            (ITreeCursorImpl&) const;

  bool SetToRoot        (ITreeCursorImpl&) const;

  void     operator=        (IMultiwayTreeImpl const&);

protected:

  void     Assign           (void*, void const*) const;

  void*    CreateNode       (void const*) const;

  void     DeleteNode       (void*) const;

private:

  enum { kOriginalVersion };

  static
  char const*
           cvClassName;

  Node*    ivRoot;

  INumber  ivNumberOfChildren;

  bool AllElementsDoSubtree
                            (IApplFunc,
                             ITreeIterationOrder, void*, Node*);

  bool CheckCursorSubtree
                            (ITreeCursorImpl const&, Node*) const;

  Node*    CopySubtree      (Node const*) const;

  INumber  DeleteSubtree    (Node*) const;

  void*    ElementOf        (Node const*) const;

  void     InitNode         (Node*, Node*) const;

  bool IsConsistentSubtree
                            (Node*) const;

  static
  Node*&   NodeOf           (ITreeCursorImpl const&);

  INumber  NumberOfSubtreeElements
                            (Node const*) const;

  INumber  NumberOfSubtreeLeaves
                            (Node const*) const;

  static
  Ops&     OpsOf            (IMultiwayTreeImpl const&);

#if ! defined (__INO_STREAMING__)
private:
  Node*    StreamInSubtree  (IDataStream&) const;

  void     StreamOutSubtree (Node const*, IDataStream&) const;

protected:
  void*    CreateNodeWithStreamer
                            (IDataStream&) const;

  void     ReadTreeStructure  (IDataStream&);

  void     WriteTreeStructure (IDataStream&) const;

public:
  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif
























































};

class IC_EXPORTC IAMultiwayTreeOps {
public:

  virtual ~IAMultiwayTreeOps
                            ();

  virtual
  void     Assign           (void*, void const*) const = 0;

  virtual
  IATreeImpl*
           Clone            () const = 0;

  virtual
  void*    CreateNode       (void const*) const = 0;

  virtual
  void     DeleteNode       (void*) const = 0;

  virtual  operator INumber () const = 0;

protected:

           IAMultiwayTreeOps
                            (bool);

private:

  bool ivContainsDTSObjects;

  friend
  class    IMultiwayTreeImpl;

#if ! defined (__INO_STREAMING__)
public:
  virtual
  void*    CreateNodeWithStreamer
                            (IACollectionStreamer*,
                             IDataStream&) const = 0;

  virtual
  void     ReadTreeStructure (IDataStream&) = 0;

  virtual
  void     WriteTreeStructure (IDataStream&) const = 0;

#endif















};

template <INumber numOfChildren, class Element,
          class ElementOps, class Implementation>
class IC_EXPORTC IMultiwayTreeOps : public IAMultiwayTreeOps {

  typedef  IAMultiwayTreeOps Inherited;

  typedef  IMultiwayTreeOps <numOfChildren, Element,
                             ElementOps, Implementation> Self;

  typedef  IMultiwayTreeNodeImpl <numOfChildren, Element> Node;

public:

           IMultiwayTreeOps ();

           IMultiwayTreeOps (void*);

           IMultiwayTreeOps (IMultiwayTreeOps
                              <numOfChildren, Element,
                               ElementOps, Implementation> const&);

          ~IMultiwayTreeOps ();

  void     Assign           (void*, void const*) const;

  IATreeImpl*
           Clone            () const;

  void*    CreateNode       (void const*) const;

  void     DeleteNode       (void*) const;

           operator INumber () const;

           operator Implementation*
                            ();



















protected:

private:

  ElementOps
           ivElementOps;

  Implementation
           ivImpl;

#if ! defined (__INO_STREAMING__)
public:
  void*    CreateNodeWithStreamer
                            (IACollectionStreamer*, IDataStream&) const;

  void     ReadTreeStructure (IDataStream&);

  void     WriteTreeStructure (IDataStream&) const;
#endif










};

#pragma pack (pop)
#pragma enum (pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif






#pragma info (restore)


#include <iimwt.inl>




#if ! defined (__TEMPINC__)
#include <iimwt.c>
#endif


#endif // _IIMWT_
