// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 62 1.6.1.3 source/core/collect/iimapks.h, collection, ioc.v400, 980918 
#ifndef _IIMAPKS_
#define _IIMAPKS_

#include <ilanglvl.hpp>
#include <iiamap.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Base>
class IMapOnKeySetMngCursorImpl;

template <class Base>
class IMapOnKeySetImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Base>
class IC_EXPORTC IMapOnKeySetMngCursorImpl : public Base::MngCursor
{

  typedef TYPENAME Base::MngCursor Inherited;

public:

           IMapOnKeySetMngCursorImpl
                            (IMapOnKeySetImpl <Base> const&);

          ~IMapOnKeySetMngCursorImpl
                            ();

protected:

private:









};

template <class Base>
class IAMapOnKeySetOps;

template <class Base>
class IC_EXPORTC IMapOnKeySetImpl : public IAMapImpl {

  typedef  IAMapImpl Inherited;

  typedef  IMapOnKeySetImpl <Base> Self;

public:

  typedef  IAMapOnKeySetOps <Base> Ops;

  typedef TYPENAME Base::Cursor Cursor;

  typedef  IMapOnKeySetMngCursorImpl <Base> MngCursor;

           IMapOnKeySetImpl (Ops&, INumber);

           IMapOnKeySetImpl (Ops&, IMapOnKeySetImpl <Base> const&);

          ~IMapOnKeySetImpl ();

  bool Add              (void const*, ICursorImpl&);

  bool AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  bool CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  bool Contains         (void const*) const;

  bool ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  bool ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementWithKey   (void const*) const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFull           () const;

  void*    Key              (void const*) const;

  bool Locate           (void const*, ICursorImpl&) const;

  bool LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  bool LocateOrAdd      (void const*, ICursorImpl&);

  bool LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfElements () const;

  bool Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  bool RemoveElementWithKey
                            (void const*);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  bool ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  void     operator=        (IMapOnKeySetImpl <Base> const&);

  bool operator==       (IAMapImpl const&) const;

protected:

  bool EqualElements    (void const*, void const*) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (IMapOnKeySetImpl <Base> const&);

  static
  Ops&     OpsOf            (IMapOnKeySetImpl <Base> const&);

  friend
  class    IMapOnKeySetMngCursorImpl <Base>;

#if ! defined (__INO_STREAMING__)
public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif


















};

template <class Base>
class IC_EXPORTC IAMapOnKeySetOps {
public:

  virtual ~IAMapOnKeySetOps ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  bool EqualElements    (void const*, void const*) const = 0;

  virtual  operator Base&   () = 0;

protected:

private:









};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iimapks.inl>


#pragma info (restore)


#endif // _IIMAPKS_
