// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 54 1.6.1.3 source/core/collect/iimapbst.h, collection, ioc.v400, 980918 
#ifndef _IIMAPBST_
#define _IIMAPBST_

#include <iimapks.h>
#include <iiksbst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IMapOnKeySetImpl
         <IKeySetAsBstTreeImpl> IMapAsBstTreeImpl;

typedef IAMapOnKeySetOps
         <IKeySetAsBstTreeImpl> IAMapAsAsBstTreeOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IMapAsBstTreeOps :
  public IAMapAsAsBstTreeOps {

  typedef  IMapAsBstTreeOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  IKeySetAsBstTreeOps
            <Element, _Key,
             ElementOps, IKeySetAsBstTreeImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IMapAsBstTreeOps
                           (INumber);

           IMapAsBstTreeOps
                           (INumber, void*);

           IMapAsBstTreeOps
                           (IMapAsBstTreeOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IMapAsBstTreeOps
                           ();

  IACollectionImpl*
           Clone           () const;

  bool     EqualElements    (void const*, void const*) const;

           operator IKeySetAsBstTreeImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#include <iimapbst.c>



#pragma info (restore)


#endif // _IIMAPBST_
