// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 48 1.6.1.3 source/core/collect/iikstab.h, collection, ioc.v400, 980918 
#ifndef _IIKSTAB_
#define _IIKSTAB_

#include <iikskss.h>
#include <iiksstab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IKeySetOnKeySortedSetImpl
         <IKeySortedSetAsTableImpl> IKeySetAsTableImpl;

typedef IAKeySetOnKeySortedSetOps
         <IKeySortedSetAsTableImpl> IAKeySetAsTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IKeySetAsTableOps :
  public IAKeySetAsTableOps {

  typedef  IKeySetAsTableOps
            <Element, Key, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsTableOps
            <Element, Key,
             ElementOps, IKeySortedSetAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  Key KeyType;

           IKeySetAsTableOps
                           (INumber);

           IKeySetAsTableOps
                           (INumber, void*);

           IKeySetAsTableOps
                           (IKeySetAsTableOps
                             <Element, Key,
                              ElementOps, Implementation> const&);

          ~IKeySetAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsTableImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#include <iikstab.c>



#pragma info (restore)


#endif // _IIKSTAB_
