// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 41 1.6.1.3 source/core/collect/iikssseq.h, collection, ioc.v400, 980918 
#ifndef _IIKSSSEQ_
#define _IIKSSSEQ_

#include <ilanglvl.hpp>
#include <iiakss.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Base>
class IKeySortedSetOnSequenceMngCursorImpl;

template <class Base>
class IKeySortedSetOnSequenceImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Base>
class IC_EXPORTC IKeySortedSetOnSequenceMngCursorImpl : public Base::MngCursor
{
  typedef TYPENAME Base::MngCursor Inherited;

public:

           IKeySortedSetOnSequenceMngCursorImpl
                            (IKeySortedSetOnSequenceImpl <Base> const&);

          ~IKeySortedSetOnSequenceMngCursorImpl
                            ();

protected:

private:










};

template <class Base>
class IKeySetOnKeySortedSetImpl;

template <class Base>
class ISortedBagOnKeySortedSetImpl;

template <class Base>
class ISortedMapOnKeySortedSetImpl;

template <class Base>
class IAKeySortedSetOnSequenceOps;

template <class Base>
class IC_EXPORTC IKeySortedSetOnSequenceImpl : public IAKeySortedSetImpl {

  typedef  IAKeySortedSetImpl Inherited;

  typedef  IKeySortedSetOnSequenceImpl <Base> Self;

public:

  typedef  IAKeySortedSetOnSequenceOps <Base> Ops;

  typedef TYPENAME Base::Cursor Cursor;

  typedef  IKeySortedSetOnSequenceMngCursorImpl <Base> MngCursor;

           IKeySortedSetOnSequenceImpl
                            (Ops&, INumber);

           IKeySortedSetOnSequenceImpl
                            (Ops&,
                             IKeySortedSetOnSequenceImpl <Base> const&);

          ~IKeySortedSetOnSequenceImpl
                            ();

  bool Add              (void const*, ICursorImpl&);

  bool AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  bool CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  bool ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  bool ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    ElementWithKey   (void const*) const;

  void*    First            () const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFirstAt        (ICursorImpl const&) const;

  bool IsFull           () const;

  bool IsLastAt         (ICursorImpl const&) const;

  void*    Key              (void const*) const;

  void*    Last             () const;

  bool LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  bool LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  bool LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfElements () const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  bool RemoveElementWithKey
                            (void const*);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition position, void const*);

  bool ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToLast        (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  bool SetToPrevious    (ICursorImpl&) const;

  void     operator=        (IKeySortedSetOnSequenceImpl <Base> const&);

protected:

  long     CompareKeys      (void const*, void const*, IArgType) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  void const*
           ivKey;

  static
  Base&    BaseOf           (IKeySortedSetOnSequenceImpl <Base> const&);

  bool LocateKey        (void const*, ICursorImpl&) const;

  bool LocateNextKey    (void const*, ICursorImpl&) const;

  static
  Ops&     OpsOf            (IKeySortedSetOnSequenceImpl <Base> const&);

  friend
  class    IKeySortedSetOnSequenceMngCursorImpl <Base>;

  friend
  class    IKeySetOnKeySortedSetImpl <Self>;

  friend
  class    ISortedBagOnKeySortedSetImpl <Self>;

  friend
  class    ISortedMapOnKeySortedSetImpl <Self>;

#if ! defined (__INO_STREAMING__)
public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif


























};

template <class Base>
class IC_EXPORTC IAKeySortedSetOnSequenceOps {
public:

  virtual ~IAKeySortedSetOnSequenceOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  long     CompareKeys      (void const*, void const*,
                             IArgType) const = 0;

  virtual
  void*    Key              (void const*) const = 0;

  virtual  operator Base&   () = 0;

protected:

private:










};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iikssseq.inl>


#pragma info (restore)


#endif // _IIKSSSEQ_
