// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 39 1.6.1.3 source/core/collect/iiksslst.h, collection, ioc.v400, 980918 
#ifndef _IIKSSLST_
#define _IIKSSLST_

#include <iikssseq.h>
#include <iiseqlst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IKeySortedSetOnSequenceImpl
         <ISequenceAsListImpl> IKeySortedSetAsListImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IKeySortedSetAsListOps :
  public IAKeySortedSetOnSequenceOps <ISequenceAsListImpl> {

  typedef  IKeySortedSetAsListOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  ISequenceAsListOps
            <Element, ElementOps, ISequenceAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IKeySortedSetAsListOps
                           (INumber);

           IKeySortedSetAsListOps
                           (INumber, void*);

           IKeySortedSetAsListOps
                           (IKeySortedSetAsListOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IKeySortedSetAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

  long     CompareKeys     (void const*, void const*, IArgType) const;

  void*    Key             (void const*) const;

           operator ISequenceAsListImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;
 
  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#include <iiksslst.c>



#pragma info (restore)


#endif // _IIKSSLST_
