// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 36 1.6.1.4 source/core/collect/iikssdil.h, collection, ioc.v400, 980918 
#ifndef _IIKSSDIL_
#define _IIKSSDIL_

#include <iikssseq.h>
#include <iiseqdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IKeySortedSetOnSequenceImpl
         <ISequenceAsDilTableImpl> IKeySortedSetAsDilTableImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IKeySortedSetAsDilTableOps :
  public IAKeySortedSetOnSequenceOps <ISequenceAsDilTableImpl> {

  typedef  IKeySortedSetAsDilTableOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  ISequenceAsDilTableOps
            <Element, ElementOps, ISequenceAsDilTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IKeySortedSetAsDilTableOps
                           (INumber);

           IKeySortedSetAsDilTableOps
                           (INumber, void*);

           IKeySortedSetAsDilTableOps
                           (IKeySortedSetAsDilTableOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IKeySortedSetAsDilTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

  long     CompareKeys     (void const*, void const*, IArgType) const;

  void*    Key             (void const*) const;

           operator ISequenceAsDilTableImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iikssdil.c>
#endif



#pragma info (restore)


#endif // _IIKSSDIL_
