// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 25 1.6.1.3 source/core/collect/iikslst.h, collection, ioc.v400, 980918 
#ifndef _IIKSLST_
#define _IIKSLST_

#include <iikskss.h>
#include <iiksslst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IKeySetOnKeySortedSetImpl
         <IKeySortedSetAsListImpl> IKeySetAsListImpl;

typedef IAKeySetOnKeySortedSetOps
         <IKeySortedSetAsListImpl> IAKeySetAsListOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IKeySetAsListOps :
  public IAKeySetAsListOps {

  typedef  IKeySetAsListOps
            <Element, Key, ElementOps, Implementation> Self;

  typedef  IKeySortedSetAsListOps
            <Element, Key,
             ElementOps, IKeySortedSetAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  Key KeyType;

           IKeySetAsListOps
                           (INumber);

           IKeySetAsListOps
                           (INumber, void*);

           IKeySetAsListOps
                           (IKeySetAsListOps
                             <Element, Key,
                              ElementOps, Implementation> const&);

          ~IKeySetAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedSetAsListImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#include <iikslst.c>



#pragma info (restore)


#endif // _IIKSLST_
