// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 21 1.6.1.3 source/core/collect/iikskss.h, collection, ioc.v400, 980918 
#ifndef _IIKSKSS_
#define _IIKSKSS_

#include <ilanglvl.hpp>
#include <iiaks.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Base>
class IKeySetOnKeySortedSetMngCursorImpl;

template <class Base>
class IKeySetOnKeySortedSetImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Base>
class IC_EXPORTC IKeySetOnKeySortedSetMngCursorImpl : public Base::MngCursor
{
  typedef TYPENAME Base::MngCursor Inherited;

public:

           IKeySetOnKeySortedSetMngCursorImpl
                            (IKeySetOnKeySortedSetImpl <Base> const&);

          ~IKeySetOnKeySortedSetMngCursorImpl
                            ();

protected:

private:









};

template <class Base>
class IBagOnKeySetImpl;

template <class Base>
class IAKeySetOnKeySortedSetOps;

template <class Base>
class IC_EXPORTC IKeySetOnKeySortedSetImpl : public IAKeySetImpl {

  typedef  IAKeySetImpl Inherited;

  typedef  IKeySetOnKeySortedSetImpl <Base> Self;

public:

  typedef  IAKeySetOnKeySortedSetOps <Base> Ops;

  typedef TYPENAME Base::Cursor Cursor;

  typedef  IKeySetOnKeySortedSetMngCursorImpl <Base> MngCursor;

           IKeySetOnKeySortedSetImpl
                            (Ops&, INumber);

           IKeySetOnKeySortedSetImpl
                            (Ops&,
                             IKeySetOnKeySortedSetImpl <Base> const&);

          ~IKeySetOnKeySortedSetImpl
                            ();

  bool Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  bool AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  bool CheckReplacement (ICursorImpl const&, void const* ) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  bool ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  bool ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementWithKey   (void const*) const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFull           () const;

  void*    Key              (void const*) const;

  bool LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  bool LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfElements () const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  bool RemoveElementWithKey
                            (void const*);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  bool ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  void     operator=        (IKeySetOnKeySortedSetImpl <Base> const&);

protected:

  bool EqualKeys        (void const*, void const*, IArgType) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (IKeySetOnKeySortedSetImpl <Base> const&);

  static
  Ops&     OpsOf            (IKeySetOnKeySortedSetImpl <Base> const&);

  friend
  class    IKeySetOnKeySortedSetMngCursorImpl <Base>;

  friend
  class    IKeySetOnKeySortedSetImpl <Base>;

  friend
  class    IBagOnKeySetImpl <Self>;

#if ! defined (__INO_STREAMING__)
public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif





















};

template <class Base>
class IC_EXPORTC IAKeySetOnKeySortedSetOps 
{
public:

  virtual ~IAKeySetOnKeySortedSetOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual  operator Base&   () = 0;

protected:

private:








};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iikskss.inl>


#pragma info (restore)


#endif // _IIKSKSS_
