// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 18 1.6.1.3 source/core/collect/iikskb.h, collection, ioc.v400, 980918 
#ifndef _IIKSKB_
#define _IIKSKB_

#include <ilanglvl.hpp>
#include <iiaks.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Base>
class IKeySetOnKeyBagMngCursorImpl;

template <class Base>
class IKeySetOnKeyBagImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Base>
class IC_EXPORTC IKeySetOnKeyBagMngCursorImpl : public Base::MngCursor 
{

  typedef TYPENAME Base::MngCursor Inherited;

public:

           IKeySetOnKeyBagMngCursorImpl
                            (IKeySetOnKeyBagImpl <Base> const&);

          ~IKeySetOnKeyBagMngCursorImpl
                            ();

protected:

private:









};

template <class Base>
class IBagOnKeySetImpl;

template <class Base>
class IAKeySetOnKeyBagOps;

template <class Base>
class IC_EXPORTC IKeySetOnKeyBagImpl : public IAKeySetImpl {

  typedef  IAKeySetImpl Inherited;

  typedef  IKeySetOnKeyBagImpl <Base> Self;

public:

  typedef  IAKeySetOnKeyBagOps <Base> Ops;

  typedef TYPENAME Base::Cursor Cursor;

  typedef  IKeySetOnKeyBagMngCursorImpl <Base> MngCursor;

           IKeySetOnKeyBagImpl
                            (Ops&, INumber);

           IKeySetOnKeyBagImpl
                            (Ops&, IKeySetOnKeyBagImpl <Base> const&);

          ~IKeySetOnKeyBagImpl
                            ();

  bool Add              (void const*, ICursorImpl&);

  bool AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  bool CheckReplacement (ICursorImpl const&, void const* ) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  bool ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  bool ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  ICursorImpl*
           CreateCursor     () const;

  ICursorImpl*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementWithKey   (void const*) const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFull           () const;

  void*    Key              (void const*) const;

  bool LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  bool LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfElements () const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  bool RemoveElementWithKey
                            (void const*);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  bool ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  void     operator=        (IKeySetOnKeyBagImpl <Base> const&);

protected:

  bool EqualKeys        (void const*, void const*, IArgType) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (IKeySetOnKeyBagImpl <Base> const&);

  static
  Ops&     OpsOf            (IKeySetOnKeyBagImpl <Base> const&);

  friend
  class    IKeySetOnKeyBagMngCursorImpl <Base>;

  friend
  class    IBagOnKeySetImpl <Self>;

#if ! defined (__INO_STREAMING__)
public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif





















};

template <class Base>
class IC_EXPORTC IAKeySetOnKeyBagOps {
public:

  virtual ~IAKeySetOnKeyBagOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual  operator Base&   () = 0;

protected:

private:








};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iikskb.inl>


#pragma info (restore)


#endif // _IIKSKB_
