// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 03 1.6.1.3 source/core/collect/iiksbseq.h, collection, ioc.v400, 980918 
#ifndef _IIKSBSEQ_
#define _IIKSBSEQ_

#include <ilanglvl.hpp>
#include <iiaksb.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Base>
class IKeySortedBagOnSequenceMngCursorImpl;

template <class Base>
class IKeySortedBagOnSequenceImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Base>
class IC_EXPORTC IKeySortedBagOnSequenceMngCursorImpl : public Base::MngCursor 
{
  typedef TYPENAME Base::MngCursor Inherited;

public:

           IKeySortedBagOnSequenceMngCursorImpl
                            (IKeySortedBagOnSequenceImpl <Base> const&);

          ~IKeySortedBagOnSequenceMngCursorImpl
                            ();

protected:

private:










};

template <class Base>
class ISortedRelationOnKeySortedBagImpl;

template <class Base>
class IKeyBagOnKeySortedBagImpl;

template <class Base>
class IAKeySortedBagOnSequenceOps;

template <class Base>
class IC_EXPORTC IKeySortedBagOnSequenceImpl : public IAKeySortedBagImpl {

  typedef  IAKeySortedBagImpl Inherited;

  typedef  IKeySortedBagOnSequenceImpl <Base> Self;

public:

  typedef  IAKeySortedBagOnSequenceOps <Base> Ops;

  typedef TYPENAME Base::Cursor Cursor;

  typedef  IKeySortedBagOnSequenceMngCursorImpl <Base> MngCursor;

           IKeySortedBagOnSequenceImpl
                            (Ops&, INumber);

           IKeySortedBagOnSequenceImpl
                            (Ops&,
                             IKeySortedBagOnSequenceImpl <Base> const&);

          ~IKeySortedBagOnSequenceImpl
                            ();

  bool Add              (void const*, ICursorImpl&);

  bool AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  bool CheckReplacement (ICursorImpl const&, void const*) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  bool ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  bool ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementAtPosition
                            (IPosition) const;

  void*    ElementWithKey   (void const*) const;

  void*    First            () const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFirstAt        (ICursorImpl const&) const;

  bool IsFull           () const;

  bool IsLastAt         (ICursorImpl const&) const;

  void*    Key              (void const*) const;

  void*    Last             () const;

  bool LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  bool LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  bool LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfDifferentKeys
                            () const;

  INumber  NumberOfElements () const;

  INumber  NumberOfElementsWithKey
                            (void const*) const;

  IPosition
           PositionAt       (ICursorImpl const&) const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  bool RemoveElementWithKey
                            (void const*);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     ReplaceAtPosition
                            (IPosition, void const*);

  bool ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToLast        (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  bool SetToNextWithDifferentKey
                            (ICursorImpl&) const;

  void     SetToPosition    (IPosition, ICursorImpl&) const;

  bool SetToPrevious    (ICursorImpl&) const;

  void     operator=        (IKeySortedBagOnSequenceImpl <Base> const&);

protected:

  long     CompareKeys      (void const*, void const*, IArgType) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  void const*
           ivKey;





  struct Predicate {

    typedef  IKeySortedBagOnSequenceImpl <Base> KSB;

    static
    bool IsEqual          (void const*, void*);

  };





  static
  Base&    BaseOf           (IKeySortedBagOnSequenceImpl <Base> const&);

  bool LocateKey        (void const*, ICursorImpl&) const;

  bool LocateNextKey    (void const*, ICursorImpl&) const;

  static
  Ops&     OpsOf            (IKeySortedBagOnSequenceImpl <Base> const&);

  friend
  struct   Predicate;

  friend
  class    IKeySortedBagOnSequenceMngCursorImpl <Base>;

  friend
  class    ISortedRelationOnKeySortedBagImpl <Self>;

  friend
  class    IKeyBagOnKeySortedBagImpl <Self>;

#if ! defined (__INO_STREAMING__)
public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif


























};

template <class Base>
class IC_EXPORTC IAKeySortedBagOnSequenceOps {
public:

  virtual ~IAKeySortedBagOnSequenceOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual
  long     CompareKeys      (void const*, void const*,
                             IArgType) const = 0;

  virtual
  void*    Key              (void const*) const = 0;

  virtual  operator Base&   () = 0;

protected:

private:










};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iiksbseq.inl>


#pragma info (restore)


#endif // _IIKSBSEQ_
