// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 01 1.6.1.4 source/core/collect/iiksblst.h, collection, ioc.v400, 980918 
#ifndef _IIKSBLST_
#define _IIKSBLST_

#include <iiksbseq.h>
#include <iiseqlst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IKeySortedBagOnSequenceImpl
         <ISequenceAsListImpl> IKeySortedBagAsListImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class _Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IKeySortedBagAsListOps :
  public IAKeySortedBagOnSequenceOps <ISequenceAsListImpl> {

  typedef  IKeySortedBagAsListOps
            <Element, _Key, ElementOps, Implementation> Self;

  typedef  ISequenceAsListOps
            <Element, ElementOps, ISequenceAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  _Key KeyType;

           IKeySortedBagAsListOps
                           (INumber);

           IKeySortedBagAsListOps
                           (INumber, void*);

           IKeySortedBagAsListOps
                           (IKeySortedBagAsListOps
                             <Element, _Key,
                              ElementOps, Implementation> const&);

          ~IKeySortedBagAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

  long     CompareKeys     (void const*, void const*, IArgType) const;

  void*    Key             (void const*) const;

           operator ISequenceAsListImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  ElementOps
           ivElementOps;

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iiksblst.c>
#endif



#pragma info (restore)


#endif // _IIKSBLST_
