// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 90 1.6.1.3 source/core/collect/iikbtab.h, collection, ioc.v400, 980918 
#ifndef _IIKBTAB_
#define _IIKBTAB_

#include <iikbksb.h>
#include <iiksbtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IKeyBagOnKeySortedBagImpl
         <IKeySortedBagAsTableImpl> IKeyBagAsTableImpl;

typedef IAKeyBagOnKeySortedBagOps
         <IKeySortedBagAsTableImpl> IAKeyBagAsTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IKeyBagAsTableOps :
  public IAKeyBagAsTableOps {

  typedef  IKeyBagAsTableOps
            <Element, Key, ElementOps, Implementation> Self;

  typedef  IKeySortedBagAsTableOps
            <Element, Key,
             ElementOps, IKeySortedBagAsTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  Key KeyType;

           IKeyBagAsTableOps
                           (INumber);

           IKeyBagAsTableOps
                           (INumber, void*);

           IKeyBagAsTableOps
                           (IKeyBagAsTableOps
                             <Element, Key,
                              ElementOps, Implementation> const&);

          ~IKeyBagAsTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedBagAsTableImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#include <iikbtab.c>



#pragma info (restore)


#endif // _IIKBTAB_
