// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 87 1.6.1.4 source/core/collect/iikblst.h, collection, ioc.v400, 980918 
#ifndef _IIKBLST_
#define _IIKBLST_

#include <iikbksb.h>
#include <iiksblst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IKeyBagOnKeySortedBagImpl
         <IKeySortedBagAsListImpl> IKeyBagAsListImpl;

typedef IAKeyBagOnKeySortedBagOps
         <IKeySortedBagAsListImpl> IAKeyBagAsListOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key,
          class ElementOps, class Implementation>
class IC_EXPORTC IKeyBagAsListOps :
  public IAKeyBagAsListOps {

  typedef  IKeyBagAsListOps
            <Element, Key, ElementOps, Implementation> Self;

  typedef  IKeySortedBagAsListOps
            <Element, Key,
             ElementOps, IKeySortedBagAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  Key KeyType;

           IKeyBagAsListOps
                           (INumber);

           IKeyBagAsListOps
                           (INumber, void*);

           IKeyBagAsListOps
                           (IKeyBagAsListOps
                             <Element, Key,
                              ElementOps, Implementation> const&);

          ~IKeyBagAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator IKeySortedBagAsListImpl&
                           ();

           operator Implementation*
                           ();


















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#if ! defined (__TEMPINC__)
#include <iikblst.c>
#endif



#pragma info (restore)


#endif // _IIKBLST_
