// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 83 1.6.1.3 source/core/collect/iikbksb.h, collection, ioc.v400, 980918 
#ifndef _IIKBKSB_
#define _IIKBKSB_

#include <ilanglvl.hpp>
#include <iiakb.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Base>
class IKeyBagOnKeySortedBagMngCursorImpl;

template <class Base>
class IKeyBagOnKeySortedBagImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Base>
class IC_EXPORTC IKeyBagOnKeySortedBagMngCursorImpl : public Base::MngCursor 
{
  typedef TYPENAME Base::MngCursor Inherited;

public:

           IKeyBagOnKeySortedBagMngCursorImpl
                            (IKeyBagOnKeySortedBagImpl <Base> const&);

          ~IKeyBagOnKeySortedBagMngCursorImpl
                            ();

protected:

private:









};

template <class Base>
class IBagOnKeyBagImpl;

template <class Base>
class IAKeyBagOnKeySortedBagOps;

template <class Base>
class IC_EXPORTC IKeyBagOnKeySortedBagImpl : public IAKeyBagImpl {

  typedef  IAKeyBagImpl Inherited;

  typedef  IKeyBagOnKeySortedBagImpl <Base> Self;

public:

  typedef  IAKeyBagOnKeySortedBagOps <Base> Ops;

  typedef TYPENAME Base::Cursor Cursor;

  typedef  IKeyBagOnKeySortedBagMngCursorImpl <Base> MngCursor;

           IKeyBagOnKeySortedBagImpl
                            (Ops&, INumber);

           IKeyBagOnKeySortedBagImpl
                            (Ops&,
                             IKeyBagOnKeySortedBagImpl <Base> const&);

          ~IKeyBagOnKeySortedBagImpl
                            ();

  bool Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  bool AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  bool CheckReplacement (ICursorImpl const&, void const* ) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  bool ContainsAllKeysFrom
                            (IACollectionImpl const&) const;

  bool ContainsElementWithKey
                            (void const*) const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  void*    ElementWithKey   (void const*) const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFull           () const;

  void*    Key              (void const*) const;

  bool LocateElementWithKey
                            (void const*, ICursorImpl&) const;

  bool LocateNextElementWithKey
                            (void const*, ICursorImpl&) const;

  bool LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  INumber  NumberOfDifferentKeys
                            () const;

  INumber  NumberOfElements () const;

  INumber  NumberOfElementsWithKey
                            (void const*) const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  bool RemoveElementWithKey
                            (void const*);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  bool ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  bool SetToNextWithDifferentKey
                            (ICursorImpl&) const;

  void     operator=        (IKeyBagOnKeySortedBagImpl <Base> const&);

protected:

  bool EqualKeys        (void const*, void const*, IArgType) const;

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (IKeyBagOnKeySortedBagImpl <Base> const&);

  static
  Ops&     OpsOf            (IKeyBagOnKeySortedBagImpl <Base> const&);

  friend
  class    IKeyBagOnKeySortedBagMngCursorImpl <Base>;

  friend
  class    IKeyBagOnKeySortedBagImpl <Base>;

  friend
  class    IBagOnKeyBagImpl <Self>;

#if ! defined (__INO_STREAMING__)
public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif





















};

template <class Base>
class IC_EXPORTC IAKeyBagOnKeySortedBagOps {
public:

  virtual ~IAKeyBagOnKeySortedBagOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual  operator Base&   () = 0;

protected:

private:








};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iikbksb.inl>


#pragma info (restore)


#endif // _IIKBKSB_
