// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 70 1.6.1.3 source/core/collect/iihpseq.h, collection, ioc.v400, 980918 
#ifndef _IIHPSEQ_
#define _IIHPSEQ_

#include <ilanglvl.hpp>
#include <iiahp.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Base>
class IHeapOnSequenceMngCursorImpl;

template <class Base>
class IHeapOnSequenceImpl;

#pragma pack(push,4)
#pragma enum(4)

template <class Base>
class IC_EXPORTC IHeapOnSequenceMngCursorImpl : public Base::MngCursor 
{

  typedef TYPENAME Base::MngCursor Inherited;

public:

           IHeapOnSequenceMngCursorImpl
                            (IHeapOnSequenceImpl <Base> const&);

          ~IHeapOnSequenceMngCursorImpl
                            ();

protected:

private:









};

template <class Base>
class IAHeapOnSequenceOps;

template <class Base>
class IC_EXPORTC IHeapOnSequenceImpl : public IAHeapImpl {

  typedef  IAHeapImpl Inherited;

  typedef  IHeapOnSequenceImpl <Base> Self;

public:

  typedef  IAHeapOnSequenceOps <Base> Ops;

  typedef TYPENAME Base::Cursor Cursor;

  typedef  IHeapOnSequenceMngCursorImpl <Base> MngCursor;

           IHeapOnSequenceImpl
                            (Ops&, INumber);

           IHeapOnSequenceImpl
                            (Ops&, IHeapOnSequenceImpl <Base> const&);

          ~IHeapOnSequenceImpl
                            ();

  bool Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  bool AllElementsDo    (IApplFunc, void*);

  void*    Any              () const;

  bool CheckCursor      (ICursorImpl const&) const;

  char const*
           ClassName        () const;

  IACollectionImpl*
           Clone            () const;

  void     Copy             (IACollectionImpl const&);

  Cursor*  CreateCursor     () const;

  MngCursor*
           CreateMngCursor  () const;

  void*    ElementAt        (ICursorImpl const&) const;

  bool IsBounded        () const;

  bool IsConsistent     () const;

  bool IsEmpty          () const;

  bool IsFull           () const;

  INumber  NumberOfElements () const;

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  void     RemoveAt         (ICursorImpl&);

  void     ReplaceAt        (ICursorImpl const&, void const*);

  bool SetToFirst       (ICursorImpl&) const;

  bool SetToNext        (ICursorImpl&) const;

  void     operator=        (IHeapOnSequenceImpl <Base> const&);

protected:

private:

  static
  char const*
           cvClassName;

  Base&    ivBase;

  static
  Base&    BaseOf           (IHeapOnSequenceImpl <Base> const&);

  static
  Ops&     OpsOf            (IHeapOnSequenceImpl <Base> const&);

  friend
  class    IHeapOnSequenceMngCursorImpl <Base>;

#if ! defined (__INO_STREAMING__)
public:
  IStreamerPtr&
           StreamerOf       (IACollectionImpl const&);

  void     StreamIn         (IDataStream&);

  void     StreamOut        (IDataStream&) const;

  void     AdoptStreamer    (IACollectionStreamer*);
#endif



















};

template <class Base>
class IC_EXPORTC IAHeapOnSequenceOps {
public:

  virtual ~IAHeapOnSequenceOps
                            ();

  virtual
  IACollectionImpl*
           Clone            () const = 0;

  virtual  operator Base&   () = 0;

protected:

private:








};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iihpseq.inl>


#pragma info (restore)


#endif // _IIHPSEQ_
