// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 68 1.6.1.3 source/core/collect/iihplst.h, collection, ioc.v400, 980918 
#ifndef _IIHPLST_
#define _IIHPLST_

#include <iihpseq.h>
#include <iiseqlst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IHeapOnSequenceImpl
         <ISequenceAsListImpl> IHeapAsListImpl;

typedef IAHeapOnSequenceOps
         <ISequenceAsListImpl> IAHeapAsListOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC IHeapAsListOps :
  public IAHeapAsListOps {

  typedef  IHeapAsListOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsListOps
            <Element, ElementOps, ISequenceAsListImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IHeapAsListOps
                           (INumber);

           IHeapAsListOps
                           (INumber, void*);

           IHeapAsListOps
                           (IHeapAsListOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IHeapAsListOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator ISequenceAsListImpl&
                           ();

           operator Implementation*
                           ();



















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#include <iihplst.c>



#pragma info (restore)


#endif // _IIHPLST_
