// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 65 1.6.1.3 source/core/collect/iihpdil.h, collection, ioc.v400, 980918 
#ifndef _IIHPDIL_
#define _IIHPDIL_

#include <iihpseq.h>
#include <iiseqdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

typedef IHeapOnSequenceImpl
         <ISequenceAsDilTableImpl> IHeapAsDilTableImpl;

typedef IAHeapOnSequenceOps
         <ISequenceAsDilTableImpl> IAHeapAsDilTableOps;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps, class Implementation>
class IC_EXPORTC IHeapAsDilTableOps :
  public IAHeapAsDilTableOps {

  typedef  IHeapAsDilTableOps
            <Element, ElementOps, Implementation> Self;

  typedef  ISequenceAsDilTableOps
            <Element, ElementOps, ISequenceAsDilTableImpl> Base;

public:

  typedef  Implementation ImplType;

  typedef  Element ElementType;

  typedef  void KeyType;

           IHeapAsDilTableOps
                           (INumber);

           IHeapAsDilTableOps
                           (INumber, void*);

           IHeapAsDilTableOps
                           (IHeapAsDilTableOps
                             <Element, ElementOps,
                              Implementation> const&);

          ~IHeapAsDilTableOps
                           ();

  IACollectionImpl*
           Clone           () const;

           operator ISequenceAsDilTableImpl&
                           ();

           operator Implementation*
                           ();



















protected:

private:

  Base     ivBase;

  Implementation
           ivImpl;












};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif








#include <iihpdil.c>



#pragma info (restore)


#endif // _IIHPDIL_
